<?php
try {
    require_once("libs/mysqlx.php");
    require_once("libs/functions.php");
    require_once("../Connections/promo.php");

    mysqlx::$connection = $promo;
    mysqlx::$dataBase = $database_promo;

    mysqlx::begin_transaction();

    $query = sprintf(
        "SELECT ORIGEN_REMOTO FROM TBL_VALCOTS WHERE IDVALCOTS = 1;"
    );

    $idorigen = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un problema al encontrar el origen de la sucursal"
            ]);
            exit;
        },
        'onEmpty' => function () {
            echo json_encode([
                "success" => false,
                "message" => "El origen de la sucursal no esta configurado"
            ]);
            exit;
        }
    ])[0]["ORIGEN_REMOTO"];

    $data = [
        "IDORIGEN" => $idorigen,
        "ACCION" => "verifica_eliminar_pago",
        "TOKEN" => "fxyGQh7UUoi5uLwAFPtvMVhhCPqk4ARHz68YuW0orJ8P070qYkt2UK1hBsvty4wD"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL            => "https://den.xnt.mx/ws/service/",
        CURLOPT_RETURNTRANSFER => true,  // Para recibir la respuesta en una variable
        CURLOPT_POST           => true,  // Método POST
        CURLOPT_POSTFIELDS     => http_build_query($data) // Los datos se envían en formato URL-encoded
    ]);

    $response = curl_exec($curl);
    $data = json_decode($response, true);
    if (curl_errno($curl)) {
        echo json_encode([
            "success" => false,
            "message" => "Ocurrio un problema al recibir las solicitudes de eliminacion de pagos",
            "response" => $data
        ]);
        curl_close($curl);
        exit;
    }
    curl_close($curl);

    if ($data["status"] == false) {
        echo json_encode([
            "success" => false,
            "message" => "Ocurrio un problema al recibir las solicitudes de eliminacion de pagos",
            "response" => $data
        ]);
        exit;
    }

    if(!isset($data["data"])){
        echo json_encode([
            "success" => false,
            "message" => "No hay pagos que procesar",
        ]);
        exit;
    }

    foreach($data["data"] as $pago){
        $query = sprintf(
            "INSERT INTO TBL_PAGOS_ELIMINADOS(
                IDSOLICITUD_AUTORIZACION,
                MONTO,
                COMENTARIO,
                IDSOLICITA,
                USUARIO_AUTORIZA,
                IDORDEN,
                IDPAGO,
                PROPINA,
                USUARIO_PAGO_ORDEN,
                COMENTARIO_GERENCIA,
                FECHA
            ) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, CURRENT_TIMESTAMP)",
            GetSQLValueString($pago["ID"], "int"),
            GetSQLValueString($pago["MONTO"], "double"),
            GetSQLValueString($pago["COMENTARIO"], "text"),
            GetSQLValueString($pago["IDSOLICITA"], "int"),
            GetSQLValueString($pago["NOMBRE_AUTORIZA"], "text"),
            GetSQLValueString($pago["IDORDEN"], "int"),
            GetSQLValueString($pago["IDPAGO"], "int"),
            GetSQLValueString($pago["PROPINA"], "double"),
            GetSQLValueString($pago["USUARIO_PAGO_ORDEN"], "text"),
            GetSQLValueString($pago["COMENTARIO_GERENCIA"], "text")
        );
        mysqlx::runQuery($query);

        $query = sprintf(
            "SELECT
                COMENTARIO_GERENCIA,
                PAGO_ELIMINADO,
                TIENE_RECOLECCION
            FROM
                TBL_PAGOS_ELIMINADOS
            WHERE
                IDSOLICITUD_AUTORIZACION = %s",
            GetSQLValueString($pago["ID"], "int")
        );
        $pago_eliminado = mysqlx::runQuery($query, [
            'onError' => function($error){
                echo json_encode([
                    "success" => false,
                    "message" => "No se pudo verificar los registros insertados " . $error
                ]);
                mysqlx::rollback();
                exit;
            },
            'onEmpty' => function(){
                echo json_encode([
                    "success" => false,
                    "message" => "No se pudo encontrar los registros insertados"
                ]);
                mysqlx::rollback();
                exit;
            }
        ]);

        if($pago_eliminado["TIENE_RECOLECCION"] == 1){
            echo json_encode([
                "success" => false,
                "message" => "No se puedo eliminar el pago, puede tener una una recoleccion."
            ]);
            $query = sprintf(
                "UPDATE 
                    TBL_PAGOS_ELIMINADOS 
                SET 
                    COMENTARIO_GERENCIA  = %s 
                WHERE 
                    IDSOLICITUD_AUTORIZACION = %s",
                GetSQLValueString($pago_eliminado["COMENTARIO_GERENCIA"] . " No se puedo eliminar el pago, puede tener una una recolecciom", "text"),
                GetSQLValueString($pago["ID"], "int")
            );
            mysqlx::runQuery($query);
            exit;
        }

        $data = [
            "ACCION" => "actualiza_pago_eliminado",
            "ID" => $pago["ID"],
            "TOKEN" => "fxyGQh7UUoi5uLwAFPtvMVhhCPqk4ARHz68YuW0orJ8P070qYkt2UK1hBsvty4wD"
        ];
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL            => "https://den.xnt.mx/ws/service/",
            CURLOPT_RETURNTRANSFER => true,  // Para recibir la respuesta en una variable
            CURLOPT_POST           => true,  // Método POST
            CURLOPT_POSTFIELDS     => http_build_query($data) // Los datos se envían en formato URL-encoded
        ]);

        $response = curl_exec($curl);
        $data = json_decode($response, true);
        if (curl_errno($curl)) {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un problema al actualizar eliminacion de pagos",
                "response" => $data
            ]);
            curl_close($curl);
            exit;
        }
        curl_close($curl);

        if ($data["status"] == false) {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un problema al actualizar eliminacion de pagos",
                "response" => $data
            ]);
            exit;
        }

    }

    echo json_encode([
        "success" => true,
        "message" => "Pagos eliminados correctamente"
    ]);
    mysqlx::commit();

} catch (\Throwable $th) {
    echo json_encode([
        "success" => false,
        "message" => "Ocurrio un problema al intentar buscar solicitudes de pagos para eliminar"
    ]);
    mysqlx::rollback();
    exit;
}
