<?php
require_once("Connections/promo.php");
require_once("Connections/mysqlx.php");

mysqlx::$connection = $promo;
mysqlx::$dataBase = $database_promo;
// error_reporting(E_ALL);

$request_body = file_get_contents('php://input');
$data = json_decode($request_body, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON', 'details' => json_last_error_msg()]);
    exit;
}

if (!isset($data["event"]) || empty($data["event"])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing or empty event field', 'details' => $data]);
    exit;
}

if ($data["event"] == "cancel_order") {

    $idorden = $data["order_id"];
    $is_paid = $data["will_be_paid"] ? 1 : 0;

    $query = sprintf(
        "UPDATE 
            TBL_ORDENES_PLATAFORMAS_HEADER 
        SET 
            IDSTATUS = 11,
            PAGADA = %s
        WHERE
            IDINTENT = %s",
        GetSQLValueString($is_paid, "int"),
        GetSQLValueString($idorden, "text")
    );
    mysqlx::runQuery($query, [
        'onError' => function ($error) {
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo actualizar el estado de la orden', 'details' => $error]);
            exit;
        }
    ]);

    http_response_code(200);
    echo json_encode(['success' => 'Order processed successfully', 'order_id' => $idorden]);
    exit;
}

if ($data["event"] == "delivery_status_changed") {

    $idorden = $data["order_id"];
    $idstatus = $data["order"]["status"];
    $idstatus_delivery = $data["delivery"]["status"];

    if ($idstatus_delivery = 1 && $idstatus == 3) {
        $nuevo_status = 5;
    }
    if ($idstatus_delivery = 2 && $idstatus == 3) {
        $nuevo_status = 6;
    }
    if ($idstatus_delivery = 3 && $idstatus == 3) {
        $nuevo_status = 7;
    }
    if ($idstatus_delivery = 4 && $idstatus == 4) {
        $nuevo_status = 8;
    }
    if ($idstatus_delivery = 5 && $idstatus == 4) {
        $nuevo_status = 9;
    }
    if ($idstatus_delivery = 6 && $idstatus == 5) {
        $nuevo_status = 10;
    }

    $query = sprintf(
        "UPDATE 
            TBL_ORDENES_PLATAFORMAS_HEADER 
        SET 
            IDSTATUS = %s
        WHERE
            IDINTENT = %s",
        GetSQLValueString($nuevo_status, "int"),
        GetSQLValueString($idorden, "text")
    );
    mysqlx::runQuery($query, [
        'onError' => function ($error) {
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo actualizar el estado de la orden', 'details' => $error]);
            exit;
        }
    ]);

    http_response_code(200);
    echo json_encode(['success' => 'Order processed successfully', 'order_id' => $idorden]);
    exit;
}

if ($data["event"] == "new_order") {
    $idorden = $data["order"]["id"];
    $display_id = $data["order"]["display_id"];
    $type = $data["order"]["type"];
    $idtype = $data["order"]["type_id"];
    $idorden_plataforma = $data["order_id"];
    $metadata = $data["metadata"] ?? null;
    $products = $data["order"]["products"] ?? [];
    $idorigen = $data["order"]["branch_id"];
    $idmenu = $data["order"]["idmenu"] ?? null;
    $menu = $data["order"]["menu"] ?? null;


    if ($type == "Uber") {
        $tipo = "4";
    }
    if ($type == "Rappi") {
        $tipo = "22";
    }
    if ($type == "Didi") {
        $tipo = "30";
    }

    mysqlx::begin_transaction();

    $query = sprintf(
        "SELECT
            IDINTENT
        FROM
            TBL_ORDENES_PLATAFORMAS_HEADER
        WHERE
            IDINTENT = %s",
        GetSQLValueString($idorden_plataforma, "text")
    );


    $result = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            mysqlx::rollback();
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo verificar el ID de la orden', 'details' => $error]);
            exit;
        }
    ])[0]["IDINTENT"] ?? null;

    if (!isset($result)) {
        $query = sprintf(
            "INSERT INTO
                TBL_ORDENES_PLATAFORMAS_HEADER(
                    FECHA,
                    ORIGEN,
                    COMENTARIO,
                    IDSTATUS,
                    TIPO,
                    XTIMESTAMP,
                    IDINTENT,
                    NOMBRE_CLIENTE,
                    IDMENU
                ) VALUES (CURRENT_TIMESTAMP(), %s, %s, 1, %s, %s, %s, %s, %s)",
            GetSQLValueString($idorigen, "text"),
            GetSQLValueString($display_id, "text"),
            GetSQLValueString($tipo, "int"),
            GetSQLValueString($idorden . $idorden_plataforma, "text"),
            GetSQLValueString($idorden_plataforma, "text"),
            GetSQLValueString($display_id, "text"),
            GetSQLValueString($idmenu, "int")
        );
        mysqlx::runQuery($query, [
            'onError' => function ($error) {
                mysqlx::rollback();
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo ingresar la orden', 'details' => $error]);
                exit;
            }
        ]);
    }

    $query_orden = sprintf(
        "SELECT
            IDORDEN
        FROM
            TBL_ORDENES_PLATAFORMAS_HEADER
        WHERE
            XTIMESTAMP = %s
            AND COMENTARIO = %s",
        GetSQLValueString($idorden . $idorden_plataforma, "text"),
        GetSQLValueString($display_id, "text")
    );

    $idorden = mysqlx::runQuery($query_orden, [
        'onError' => function ($error) {
            mysqlx::rollback();
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo obtener el ID de la orden', 'details' => $error]);
            exit;
        },
        'onEmpty' => function () use ($data) {
            mysqlx::rollback();
            http_response_code(400);
            echo json_encode(['error' => 'Order not found after insertion', 'details' => $data]);
            exit;
        }
    ])[0]["IDORDEN"];

    if ($type == "Uber" && isset($metadata) && !empty($metadata) && isset($metadata["phone"]) && !empty($metadata["phone"])) {
        $query = sprintf(
            "UPDATE
                TBL_ORDENES_PLATAFORMAS_HEADER
            SET
                TELEFONO_CLIENTE = %s,
                PIN_CODE = %s
            WHERE
                IDORDEN = %s",
            GetSQLValueString($metadata["phone"]["number"], "text"),
            GetSQLValueString($metadata["phone"]["pin_code"] ?? '', "text"),
            GetSQLValueString($idorden, "int")
        );
        mysqlx::runQuery($query);
    }

    if (!isset($products) || empty($products)) {
        mysqlx::rollback();
        http_response_code(400);
        echo json_encode(['error' => 'No products found in the order', 'details' => $data]);
        exit;
    }

    $query = sprintf(
        "INSERT INTO
            TBL_ORDENES_PLATAFORMAS_DETAIL(
                CANT,
                DESCRIPCION,
                IDSTATUS,
                IDORDEN,
                PUNIT,
                FECHA,
                IDPROD,
                CREADO,
                IDDET_PLATAFORMA,
                ESOPCION
            ) VALUES (1, %s, 1, %s, 0, CURRENT_TIMESTAMP(), 166, CURRENT_TIMESTAMP(), 0, 1)",
        GetSQLValueString($menu, "text"),
        GetSQLValueString($idorden, "int")
    );
    mysqlx::runQuery($query, [
        'onError' => function ($error) {
            mysqlx::rollback();
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo ingresar el detalle de la orden', 'details' => $error]);
            exit;
        }
    ]);

    foreach ($products as $product) {
        $idproducto = $product["external_product_id"] != 0 ? $product["external_product_id"] : $product["product_id"];
        $cantidad = $product["quantity"];
        $precio = $product["unit_price"];
        $descripcion = $product["description"];
        $idprod_plataforma = $product["platform_product_id"];

        $query = sprintf(
            "SELECT
                IDDET_PLATAFORMA
            FROM
                TBL_ORDENES_PLATAFORMAS_DETAIL
            WHERE
                IDDET_PLATAFORMA = %s
                AND IDORDEN = %s",
            GetSQLValueString($idprod_plataforma, "text"),
            GetSQLValueString($idorden, "int")
        );
        $result = mysqlx::runQuery($query, [
            'onError' => function ($error) {
                mysqlx::rollback();
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo verificar el ID del producto en la plataforma', 'details' => $error]);
                exit;
            }
        ])[0]["IDDET_PLATAFORMA"] ?? null;

        if (isset($result) && !empty($result)) {
            continue;
        }

        $query = sprintf(
            "INSERT INTO
                TBL_ORDENES_PLATAFORMAS_DETAIL(
                    CANT,
                    DESCRIPCION,
                    IDSTATUS,
                    IDORDEN,
                    PUNIT,
                    FECHA,
                    IDPROD,
                    CREADO,
                    IDDET_PLATAFORMA
                ) VALUES (%s, %s, 1, %s, %s, CURRENT_TIMESTAMP(), %s, CURRENT_TIMESTAMP(), %s)",
            GetSQLValueString($cantidad, "int"),
            GetSQLValueString($descripcion, "text"),
            GetSQLValueString($idorden, "int"),
            GetSQLValueString($precio, "double"),
            GetSQLValueString($idproducto, "int"),
            GetSQLValueString($idprod_plataforma, "text")
        );
        mysqlx::runQuery($query, [
            'onError' => function ($error) {
                mysqlx::rollback();
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo ingresar el detalle de la orden', 'details' => $error]);
                exit;
            }
        ]);

        $query = sprintf(
            "SELECT
                IDDET
            FROM
                TBL_ORDENES_PLATAFORMAS_DETAIL
            WHERE
                IDORDEN = %s
                AND IDDET_PLATAFORMA = %s",
            GetSQLValueString($idorden, "int"),
            GetSQLValueString($idprod_plataforma, "text")
        );
        $iddet = mysqlx::runQuery($query, [
            'onError' => function ($error) {
                mysqlx::rollback();
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo obtener el ID del detalle de la orden', 'details' => $error]);
                exit;
            }
        ])[0]["IDDET"];

        foreach ($product["details"] as $value) {

            $cantidad = $value["quantity"];
            $descripcion = $value["description"];
            $idprod_plataforma = $value["platform_product_id"];
            $idproducto = $value["external_product_id"] != 0 ? $value["external_product_id"] : $value["product_id"];
            $precio = $value["unit_price"];

            $query = sprintf(
                "SELECT
                    IDDET_PLATAFORMA
                FROM
                    TBL_ORDENES_PLATAFORMAS_DETAIL
                WHERE
                    IDDET_PLATAFORMA = %s
                    AND IDORDEN = %s",
                GetSQLValueString($idprod_plataforma, "text"),
                GetSQLValueString($idorden, "int")
            );
            $result = mysqlx::runQuery($query, [
                'onError' => function ($error) {
                    mysqlx::rollback();
                    http_response_code(500);
                    echo json_encode(['error' => 'No se pudo verificar el ID del producto en la plataforma', 'details' => $error]);
                    exit;
                }
            ])[0]["IDDET_PLATAFORMA"] ?? null;

            if (isset($result) && !empty($result)) {
                continue;
            }

            $query = sprintf(
                "INSERT INTO
                    TBL_ORDENES_PLATAFORMAS_DETAIL(
                        CANT,
                        DESCRIPCION,
                        IDSTATUS,
                        IDORDEN,
                        PUNIT,
                        FECHA,
                        IDPROD,
                        CREADO,
                        IDDET_PLATAFORMA,
                        ESOPCION,
                        IDOPC
                    ) VALUES (%s, %s, 1, %s, %s, CURRENT_TIMESTAMP(), %s, CURRENT_TIMESTAMP(), %s, 1, %s)",
                GetSQLValueString($cantidad, "int"),
                GetSQLValueString($descripcion, "text"),
                GetSQLValueString($idorden, "int"),
                GetSQLValueString($precio, "double"),
                GetSQLValueString($idproducto, "int"),
                GetSQLValueString($idprod_plataforma, "text"),
                GetSQLValueString($iddet, "int")
            );
            mysqlx::runQuery($query, [
                'onError' => function ($error) {
                    mysqlx::rollback();
                    http_response_code(500);
                    echo json_encode(['error' => 'No se pudo ingresar el detalle de la opcion de la orden', 'details' => $error]);
                    exit;
                }
            ]);
        }
    }

    $query = sprintf(
        "UPDATE 
            TBL_ORDENES_PLATAFORMAS_HEADER 
        SET 
            IDSTATUS = 2
        WHERE
            IDORDEN = %s",
        GetSQLValueString($idorden, "int")
    );
    mysqlx::runQuery($query, [
        'onError' => function ($error) {
            mysqlx::rollback();
            http_response_code(500);
            echo json_encode(['error' => 'No se pudo actualizar el estado de la orden', 'details' => $error]);
            exit;
        }
    ]);

    mysqlx::commit();
    http_response_code(200);
    echo json_encode(['success' => 'Order processed successfully', 'order_id' => $idorden]);
}
