<?php
define('ROUTER_ROOT', '/sxpos/services/delivery-platforms');

function get($route, $path_to_include)
{
	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		resolve($route, $path_to_include);
	}
}

function post($route, $path_to_include)
{
	if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		resolve($route, $path_to_include);
	}
}

function put($route, $path_to_include)
{
	if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
		resolve($route, $path_to_include);
	}
}

function patch($route, $path_to_include)
{
	if ($_SERVER['REQUEST_METHOD'] == 'PATCH') {
		resolve($route, $path_to_include);
	}
}

function delete($route, $path_to_include)
{
	if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
		resolve($route, $path_to_include);
	}
}

function any($route, $path_to_include)
{
	resolve($route, $path_to_include);
}

function resolveCallback($callback, $parameters = [])
{
	if (is_callable($callback)) {
		call_user_func_array($callback, $parameters);
		exit();
	}
}

function appendPhpExtensionIfNeeded(&$path_to_include)
{
	if (!is_callable($path_to_include) && !strpos($path_to_include, '.php')) {
		$path_to_include .= '.php';
	}
}

function resolve($route, $path_to_include)
{
	$callback = $path_to_include;
	appendPhpExtensionIfNeeded($path_to_include);

	if ($route == "/404") {
		resolveCallback($callback);
		require_once __DIR__ . "/$path_to_include";
		exit();
	}

	$route = ROUTER_ROOT . $route;
	$request_url = filter_var($_SERVER['REQUEST_URI'], FILTER_SANITIZE_URL);
	$request_url = rtrim($request_url, '/');
	$request_url = strtok($request_url, '?');
	$route_parts = explode('/', $route);
	$request_url_parts = explode('/', $request_url);
	array_shift($route_parts);
	array_shift($request_url_parts);

	if ($route_parts[0] == '' && count($request_url_parts) == 0) {
		resolveCallback($callback);
		require_once __DIR__ . "/$path_to_include";
		exit();
	}

	if (count($route_parts) != count($request_url_parts)) {
		return;
	}

	$parameters = [];
	for ($i = 0; $i < count($route_parts); $i++) {
		$route_part = $route_parts[$i];
		if (preg_match("/^[$]/", $route_part)) {
			$route_part = ltrim($route_part, '$');
			array_push($parameters, $request_url_parts[$i]);
			$$route_part = $request_url_parts[$i];
		} else if ($route_parts[$i] != $request_url_parts[$i]) {
			return;
		}
	}

	resolveCallback($callback, $parameters);
	require_once __DIR__ . "/$path_to_include";
	exit();
}

function out($text)
{
	echo htmlspecialchars($text);
}

function set_csrf()
{
	if (!isset($_SESSION["csrf"])) {
		$_SESSION["csrf"] = bin2hex(random_bytes(50));
	}
	echo '<input type="hidden" name="csrf" value="' . $_SESSION["csrf"] . '">';
}

function is_csrf_valid()
{
	if (!isset($_SESSION['csrf']) || !isset($_POST['csrf'])) {
		return false;
	}
	return ($_SESSION['csrf'] === $_POST['csrf']);
}
