<?
if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
    {

        $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

        switch ($theType) {
            case "text":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue != "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
                break;
            case "date":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
                break;
        }
        return $theValue;
    }
}

function formatMoney($monto){
    return (double)number_format($monto, 2, '.', '');
}

function diee($str, $code = 0)
{
    throw new Exception($str, $code);
}

function encrypt($key, $data)
{
    $encryptionKey = base64_decode($key);
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-gcm'));
    $encrypted = openssl_encrypt($data, 'aes-256-gcm', $encryptionKey, 0, $iv, $tag);
    return $encrypted . ':' . base64_encode($iv) . ':' . base64_encode($tag);
}

function decrypt($key, $data)
{
    $encryptionKey = base64_decode($key);
    list($encryptedData, $iv, $tag) = explode(':', $data, 3);
    return openssl_decrypt($encryptedData, 'aes-256-gcm', $encryptionKey, 0, base64_decode($iv), base64_decode($tag));
}

function validate_array_structure(array $array, array $expected_structure)
{
    foreach ($expected_structure as $key => $requirements) {
        if (!is_array($requirements)) {
            return false; // Requisitos no válidos
        }

        $type = $requirements[0];
        $optional = $requirements[1];
        $validator = isset($requirements[2]) ? $requirements[2] : null;

        if (!array_key_exists($key, $array)) {
            if (!$optional) {
                continue; // Campo opcional faltante, continuar
            } else {
                return false; // Campo obligatorio faltante
            }
        }

        $value = $array[$key];

        // Verificar el tipo de valor
        switch ($type) {
            case 'string':
                if (!is_string($value)) {
                    return false;
                }
                break;
            case 'integer':
                if (!is_int($value)) {
                    return false;
                }
                break;
            case 'float':
                if (!is_float($value)) {
                    return false;
                }
                break;
            case 'double':
                if (!is_double($value)) {
                    return false;
                }
                break;
            case 'numeric':
                if (!is_numeric($value)) {
                    return false;
                }
                break;
            case 'boolean':
                if (!is_bool($value)) {
                    return false;
                }
                break;
            case 'array':
                if (!is_array($value)) {
                    return false;
                }
                break;
            case 'associative_array':
                if (!is_array($value) || array_keys($value) === range(0, count($value) - 1)) {
                    return false;
                }
                // Validar la estructura del array anidado
                if (!validate_array_structure($value, $requirements[2])) {
                    return false;
                }
                break;
            default:
                return false; // Tipo desconocido
        }

        // Aplicar el validador personalizado si está presente
        if (is_callable($validator)) {
            if (!$validator($value)) {
                return false;
            }
        }
    }

    return true; // Todos los tipos y claves son válidos
}


function validate_array_structure_2(array $array, array $expected_structure)
{
    foreach ($expected_structure as $key => $requirements) {
        if (!is_array($requirements)) {
            return [false, "Invalid requirements for key '$key'"];
        }

        $type = $requirements[0];
        $optional = $requirements[1];
        $validator = isset($requirements[2]) ? $requirements[2] : null;

        if (!array_key_exists($key, $array)) {
            if ($optional) {
                return [false, "The required field '$key' is missing."];
            } else {
                continue; // Missing optional field, continue
            }
        }

        $value = $array[$key];

        // Check the type of the value
        switch ($type) {
            case 'string':
                if (!is_string($value)) {
                    return [false, "The field '$key' must be a string."];
                }
                break;
            case 'integer':
                if (!is_int($value)) {
                    return [false, "The field '$key' must be an integer."];
                }
                break;
            case 'float':
                if (!is_float($value)) {
                    return [false, "The field '$key' must be a float."];
                }
                break;
            case 'double':
                if (!is_double($value)) {
                    return [false, "The field '$key' must be a double."];
                }
                break;
            case 'numeric':
                if (!is_numeric($value)) {
                    return [false, "The field '$key' must be numeric."];
                }
                break;
            case 'boolean':
                if (!is_bool($value)) {
                    return [false, "The field '$key' must be a boolean."];
                }
                break;
            case 'array':
                if (!is_array($value)) {
                    return [false, "The field '$key' must be an array."];
                }
                break;
            case 'associative_array':
                if (!is_array($value) || array_keys($value) === range(0, count($value) - 1)) {
                    return [false, "The field '$key' must be an object."];
                }
                // Validate the structure of the nested array
                $nested_validation = validate_array_structure_2($value, $requirements[2]);
                if (!$nested_validation[0]) {
                    return [false, $nested_validation[1]];
                }
                break;
            default:
                return [false, "Unknown type '$type' for key '$key'"];
        }

        // Apply the custom validator if present
        if (is_callable($validator)) {
            if (!$validator($value)) {
                return [false, "The value of '$key' did not pass the custom validation."];
            }
        }
    }

    return [true, "All keys and types are valid"];
}

function mkpath($path, $mode)
{
    if (@mkdir($path) or file_exists($path)) return true;
    return (mkpath(dirname($path), $mode) and mkdir($path, $mode));
}

function generarCodigo($digitos, $opciones = [])
{
    // Opciones por defecto
    $config = array_merge([
        'permitir_ceros_inicio' => true,
        'usar_random_int' => false,
        'formato' => null // 'xxx-xxx', 'xxx xxx', etc.
    ], $opciones);

    // Validaciones
    if (!is_int($digitos) || $digitos <= 0) {
        throw new InvalidArgumentException('El número de dígitos debe ser un entero positivo');
    }

    $codigo = '';

    // Primer dígito (si no se permiten ceros al inicio)
    if (!$config['permitir_ceros_inicio'] && $digitos > 1) {
        $codigo .= $config['usar_random_int'] ?
            random_int(1, 9) : mt_rand(1, 9);
        $digitos--;
    }

    // Resto de dígitos
    for ($i = 0; $i < $digitos; $i++) {
        $codigo .= $config['usar_random_int'] ?
            random_int(0, 9) : mt_rand(0, 9);
    }

    // Aplicar formato si se especifica
    if ($config['formato']) {
        $codigo = aplicarFormato($codigo, $config['formato']);
    }

    return $codigo;
}

function aplicarFormato($codigo, $formato)
{
    $posicion = 0;
    $resultado = '';

    for ($i = 0; $i < strlen($formato); $i++) {
        if ($formato[$i] === 'x' || $formato[$i] === 'X') {
            if ($posicion < strlen($codigo)) {
                $resultado .= $codigo[$posicion];
                $posicion++;
            }
        } else {
            $resultado .= $formato[$i];
        }
    }

    return $resultado;
}

function array_keys_to_lower(array $arr): array {
    $result = [];
    foreach ($arr as $key => $value) {
        // pasar la clave a string y luego a minúsculas UTF‑8
        $lowerKey = mb_strtolower((string)$key, 'UTF-8');

        // si el valor es otro array, recursar
        if (is_array($value)) {
            $result[$lowerKey] = array_keys_to_lower($value);
        } else {
            $result[$lowerKey] = $value;
        }
    }
    return $result;
}