<?php
// Verificar si la cabecera de autorización está presente
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    // Extraer el token de la cabecera
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
    preg_match('/Bearer\s(\S+)/', $authHeader, $matches);

    if (isset($matches[1])) {
        // El token está presente
        $token = $matches[1];
        // Aquí deberías implementar la lógica para validar el token
        // Por ejemplo, verificarlo contra una base de datos o un servicio externo
        if (!validarToken($token)) {
            // El token no es válido, envía un estado 401 Unauthorized
            header('HTTP/1.1 401 Unauthorized');
            throw new authException("Invalid OAuth access token.", "OAuthException", 1, 1004);
        }
    }
} else {
    // No se proporcionó ninguna cabecera de autorización
    header('HTTP/1.1 401 Unauthorized');
    throw new authException("Invalid OAuth access token.", "OAuthException", 1, 1005);
}

// Función para validar el token (esta es solo un ejemplo y debe ser implementada)
function validarToken($token)
{
    $query = sprintf(
        "SELECT ID FROM TBL_API_CLIENTES WHERE ACCESS_TOKEN = %s",
        GetSQLValueString($token, 'text')
    );

    $result = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            throw new authException("Invalid OAuth access token.", "OAuthException", 1, 1001);
        },
        'onEmpty' => function () {
            throw new authException("Invalid OAuth access token.", "OAuthException", 1, 1002);
        }
    ]);

    if (count($result) > 1) {
        throw new authException("Invalid OAuth access token.", "OAuthException", 1, 1003);
    }

    return true;
}
