<?php
// Datos a registrar en el log de acceso
$remoteAddress = $_SERVER['REMOTE_ADDR']; // Dirección IP del cliente
$requestUri = $_SERVER['REQUEST_URI']; // URI solicitada
$timestamp = date('Y-m-d H:i:s'); // Marca de tiempo actual
$headers = getallheaders(); // Obtiene todos los encabezados HTTP

// Formato del mensaje de registro
$logMessage = "[$timestamp] Acceso desde: $remoteAddress - URI solicitada: $requestUri" . PHP_EOL;
$logMessage .= "Encabezados:" . PHP_EOL;
foreach ($headers as $header => $value) {
    $logMessage .= "$header: $value" . PHP_EOL;
}
$logMessage .= PHP_EOL; // Añade una línea en blanco al final

$query = sprintf(
    "INSERT INTO TBL_API_ACCESS_LOG(FECHA, IP, URI_SOLICITADA, HEADERS) VALUES (%s, %s, %s, %s)",
    GetSQLValueString($timestamp, 'date'),
    GetSQLValueString($remoteAddress, 'text'),
    GetSQLValueString($requestUri, 'text'),
    GetSQLValueString(json_encode($headers), 'text')
);

mysqlx::runQuery($query, ['onError' => false]);
