<?php

if (!isset($storeUUID) || empty($storeUUID)) {
    throw new CustomException('No se encontró el parámetro storeUUID en la URL', UNEXPECTED_EXCEPTION, 1, 1);
}

if (!isset($orderIdWeb) || empty($orderIdWeb)) {
    throw new CustomException('No se encontró el parámetro orderIdWeb en la URL', UNEXPECTED_EXCEPTION, 1, 2);
}

$query = sprintf(
    "SELECT IDINTENT FROM TBL_ORDENES_WEB_HEADER WHERE IDORDEN = %s AND IDINTENT IS NOT NULL",
    GetSQLValueString($orderIdWeb, 'int')
);

$_ORDERWEB = mysqlx::runQuery($query, [
    'onError' => function ($error) {
        throw new CustomException($error, UNEXPECTED_EXCEPTION, 1, 3);
    },
    'onEmpty' => function () {
        throw new CustomException('No se encontró la orden', UNEXPECTED_EXCEPTION, 1, 4);
    }
])[0];

// URL del endpoint
$url = 'https://orderflow.xnt.mx/system/api/app/order/ready';

// Datos a enviar en el cuerpo de la solicitud
$payload = [
    'order_id' => $_ORDERWEB['IDINTENT'],
    'client_id'  => $storeUUID
];

// Inicializar cURL
$ch = curl_init($url);

// Configurar cURL
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => [
        'Accept: application/json'
    ],
    CURLOPT_POSTFIELDS     => $payload,
]);

// Ejecutar la solicitud
$response  = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error     = curl_error($ch);

// Cerrar conexión
curl_close($ch);

// Validar resultado
if ($error) {
    throw new CustomException("Error de conexión: $error", UNEXPECTED_EXCEPTION, 1, 6);
}

// Decodificar la respuesta JSON
$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    throw new CustomException('Respuesta JSON inválida: ' . json_last_error_msg(), UNEXPECTED_EXCEPTION, 1, 7);
}

if ($http_code !== 200) {
    throw new CustomException("Error HTTP $http_code: " . json_encode($data, JSON_UNESCAPED_UNICODE), UNEXPECTED_EXCEPTION, 1, 8, json_encode($data, JSON_UNESCAPED_UNICODE));
}

solve(RESPONSE_200, [
    'success' => true
]);
