<?php
// Allow requests from specific origin (replace with your actual origin)
header("Access-Control-Allow-Origin: *");

// Allow specific headers including Authorization
header("Access-Control-Allow-Headers: Authorization, Content-Type");

// Allow all HTTP methods
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    // Return response for preflight request
    header("HTTP/1.1 200 OK");
    exit;
}

http_response_code(500);

require_once(__DIR__ . '/../Connections/promo.php');
require_once(__DIR__ . '/../Connections/mysqlx.php');

mysqlx::$connection = $promo;
mysqlx::$dataBase = $database_promo;

try {
    if (!isset($_GET['order_id']) || empty($_GET['order_id']) || !is_numeric($_GET['order_id'])) {
        throw new Exception('No se encuentra el parametro: [order_id] en la URL');
    }

    $query = sprintf(
        "SELECT IDORDEN_WEB FROM TBL_ORDENES_PROD_HEADER WHERE IDORDEN = %s AND TIPO <> 20 AND IDORDEN_WEB IS NOT NULL",
        GetSQLValueString($_GET['order_id'], "int")
    );

    $_ORDER = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            throw new Exception($error);
        },
        'onEmpty' => function () {
            throw new Exception('No se encontró la orden');
        }
    ])[0];

    $query = sprintf(
        "SELECT CLIENT_ID FROM TBL_VARIABLES_HB WHERE IDVARIABLES = 1 AND CLIENT_ID IS NOT NULL"
    );

    $_VARIABLES = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            throw new Exception($error);
        },
        'onEmpty' => function () {
            throw new Exception('No se encontró el registro de variables');
        }
    ])[0];

    // URL del endpoint
    $url = 'https://den.xnt.mx/sxpos/services/delivery-platforms/stores/' . $_VARIABLES['CLIENT_ID'] . '/orders/' . $_ORDER['IDORDEN_WEB'] . '/mark-ready';

    // Inicializar cURL
    $ch = curl_init($url);

    // Configurar cURL
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => [
            'Accept: application/json',
            'Authorization: Bearer TuIWJ0EGtBHYzb4LKjrZC5ft0qQ0bli6YKyk9hVx0r56G2qvubu68xu2vgGPg5ZElZjvcXaiDXbXYog6ymXEETzY72CdiQTX58hOExMxAi2eluVJtpUXvqSFoh5pZ69m64yAEkHJfOSM1rcoxX2mvh8oRiS0PPa'
        ]
    ]);

    // Ejecutar la solicitud
    $response  = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error     = curl_error($ch);

    // Cerrar conexión
    curl_close($ch);

    // Validar resultado
    if ($error) {
        throw new Exception("Error de conexión: $error");
    }

    // Decodificar la respuesta JSON
    $data = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Respuesta JSON inválida: ' . json_last_error_msg());
    }

    if ($http_code !== 200) {
        throw new Exception("Error HTTP $http_code: " . json_encode($data, JSON_UNESCAPED_UNICODE));
    }


    header('Content-Type: application/json');
    http_response_code(200);
    echo json_encode([
        'success' => true
    ]);
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        'error' => [
            'message' => $e->getMessage(),
            'code' => $e->getCode()
        ]
    ]);
}