<?php
try {

    if (!isset($_POST["COMENTARIO"])) {
        echo json_encode([
            "success" => false,
            "message" => "Ingresa una razon para solicitar la eliminacion del pago."
        ]);
        exit;
    }

    if (!isset($_POST["IDSOLICITA"]) || !isset($_POST["IDPAGO"])) {
        echo json_encode([
            "success" => false,
            "message" => "Ocurrio un problema inesperado, favor de recargar la pagina e intentar de nuevo."
        ]);
        exit;
    }

    require_once("libs/mysqlx.php");
    require_once("libs/functions.php");
    require_once(__DIR__ . "/../Connections/promo.php");

    mysqlx::$connection = $promo;
    mysqlx::$dataBase = $database_promo;

    $query = sprintf(
        "SELECT
        IDPAGO,
        ABONO,
        FACTURA AS IDORDEN,
        CONCAT(COALESCE(E.emp_first_name, ''), ' ', COALESCE(E.emp_last_name, ''), ' ', COALESCE(E.emp_second_last_name, '')) EMPLEADO_PAGO,
        P.IDOPERADOR AS IDUSUARIO_PAGO,
        F.NOMBRE AS NOMBRE_FORMA_PAGO,
        P.PROPINA
    FROM
        TBL_PAGOS P
        LEFT JOIN emp_employees E ON E.employee_id = P.IDOPERADOR
        LEFT JOIN TBL_FORMA_PAGO F ON F.ID = P.IDFORMAPAGO
    WHERE
        P.IDPAGO = %s
        AND P.IDRECOLECCION = 0;",
        GetSQLValueString($_POST["IDPAGO"], "int")
    );

    $pago = mysqlx::runQuery($query, [
        'onError' => function ($error) {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un problema al buscar el pago"
            ]);
            exit;
        },
        'onEmpty' => function () {
            echo json_encode([
                "success" => false,
                "message" => "No se encontro el pago"
            ]);
            exit;
        }
    ])[0];

    // $query = sprintf(
    //     "SELECT
    //         USUARIO,
    //         CORREO,
    //         ROL,
    //         CODIGO
    //     FROM
    //         TBL_USUARIOS_AUTORIZAN
    //     WHERE
    //         ACTIVO = 1"
    // );

    // $usuarios = mysqlx::runQuery($query, [
    //     'onEmpty' => function () {
    //         echo json_encode([
    //             "success" => false,
    //             "message" => "No hay usuarios configurados para autorizar la solicitud"
    //         ]);
    //         exit;
    //     },
    //     'onError' => function () {
    //         echo json_encode([
    //             "success" => false,
    //             "message" => "Ocurrio un error al obtener los usuarios que autorizan la solicitud"
    //         ]);
    //         exit;
    //     }
    // ]);

    $query = sprintf(
        "SELECT
            ORIGEN_REMOTO
        FROM
            TBL_VALCOTS
        WHERE
            IDVALCOTS = 1
            AND ORIGEN_REMOTO IS NOT NULL"
    );

    $origen = mysqlx::runQuery($query, [
        'onEmpty' => function () {
            echo json_encode([
                "success" => false,
                "message" => "No se encontro el identificador de la sucursal"
            ]);
            exit;
        },
        'onError' => function () {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un error al obtener el identificador de la sucursal"
            ]);
            exit;
        }
    ])[0]["ORIGEN_REMOTO"];

    $query = sprintf(
        "SELECT
            CONCAT(COALESCE(E.emp_first_name, ''), ' ', COALESCE(E.emp_last_name, ''), ' ', COALESCE(E.emp_second_last_name, '')) EMPLEADO_SOLICITA
        FROM
            emp_employees E
        WHERE 
            employee_id = %s",
        GetSQLValueString($_POST["IDSOLICITA"], "int")
    );

    $nombre_solicita = mysqlx::runQuery($query, [
        'onEmpty' => function () {
            echo json_encode([
                "success" => false,
                "message" => "No se pudo encontrar informacion del usuario que solicita la eliminacion del pago"
            ]);
            exit;
        },
        'onError' => function () {
            echo json_encode([
                "success" => false,
                "message" => "Ocurrio un error al obtener la informacion del usuario que solicita la eliminacion del pago"
            ]);
            exit;
        }
    ])[0]["EMPLEADO_SOLICITA"];

    $razon = $_POST["COMENTARIO"];
    $idsolicita = $_POST["IDSOLICITA"];
    $monto = $pago["ABONO"];
    $propina = $pago["PROPINA"];
    $realiza_pago_nombre = $pago["EMPLEADO_PAGO"];
    $realiza_pago_id = $pago["IDUSUARIO_PAGO"];
    $idorden = $pago["IDORDEN"];
    $idpago = $pago["IDPAGO"];
    $tipo_pago = $pago["NOMBRE_FORMA_PAGO"];
    $idorigen = $origen;
    $fecha_solicita    = date("Y-m-d H:i:s");    

    // echo $gerencia["CORREO"];
    $data = [
        'TOKEN'            => "fxyGQh7UUoi5uLwAFPtvMVhhCPqk4ARHz68YuW0orJ8P070qYkt2UK1hBsvty4wD",
        'MONTO'            => $monto,
        'PROPINA'          => $propina,
        'COMENTARIO'       => $razon,
        'IDSOLICITA'       => $idsolicita,
        'IDPAGO'           => $idpago,
        'TIPO_PAGO'        => $tipo_pago,
        'IDORIGEN'         => $idorigen,
        'FECHA_SOLICITA'   => $fecha_solicita,
        'IDORDEN'          => $idorden,
        'REALIZO_PAGO'     => $realiza_pago_nombre,
        "NOMBRE_SOLICITA" => $nombre_solicita,
        "ACCION" => "solicitud_eliminar_pago"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL            => "https://den.xnt.mx/ws/service/",
        CURLOPT_RETURNTRANSFER => true,  // Para recibir la respuesta en una variable
        CURLOPT_POST           => true,  // Método POST
        CURLOPT_POSTFIELDS     => http_build_query($data) // Los datos se envían en formato URL-encoded
    ]);

    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        echo json_encode([
            "success" => false,
            "message" => "Ocurrio un problema al enviar la solicitud de eliminacion de pago"
        ]);
        curl_close($curl);
        exit;
    }
    curl_close($curl);

    $data = json_decode($response, true);

    if ($data["status"] == false) {
        echo json_encode([
            "success" => false,
            "message" => "Ocurrio un problema al enviar la solicitud de eliminacion de pago"
        ]);
        exit;
    }

    // LOG DE RASTREABILIDAD DE MOVIMIENTO - ccisneros/jpolanco 13/OCT/2025 BBP 3506
    $query_ins_log_movimiento = sprintf(
        "INSERT INTO TBL_LOG_MOVIMIENTOS (IDCATMOV, FECHA_MOVIMIENTO, IDOPERADOR, IDORIGEN, IDORDEN, IDPAGO, IDUSUARIO_PAGO)
        VALUES (%s, %s, %s, %s, %s, %s, %s)",
        GetSQLValueString(25, "int"),
        GetSQLValueString($fecha_solicita, "date"),
        GetSQLValueString($idsolicita, "int"),
        GetSQLValueString($_POST["IDORIGEN"], "int"),
        GetSQLValueString($idorden, "int"),
        GetSQLValueString($_POST["IDPAGO"], "int"),
        GetSQLValueString($realiza_pago_id, "int")        
    );
    //echo $query_ins_log_movimiento;
    mysql_query($query_ins_log_movimiento, $promo);


    echo json_encode([
        "success" => true,
        "message" => "Peticion colocada con exito",
        "response" => $data
    ]);
} catch (\Throwable $th) {
    echo json_encode([
        "success" => false,
        "message" => "Ocurrio un error inesperado"
    ]);
}
