<?php
if (!isset($_SESSION)) {
    session_start();
}

require_once('Connections/promo.php');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
    {
        $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

        switch ($theType) {
            case "text":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue != "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
                break;
            case "date":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
                break;
        }
        return $theValue;
    }
}

if (!isset($_SESSION['IDOPERADOR'])) {
    http_response_code(401);
    echo json_encode(array('success' => false, 'message' => 'Sesión no válida'));
    exit;
}

if (!isset($promo) || !$promo) {
    http_response_code(500);
    echo json_encode(array('success' => false, 'message' => 'Conexión a base de datos no disponible'));
    exit;
}

$idEmpleado = $_SESSION['IDOPERADOR'];
mysql_select_db($database_promo, $promo);


// GET: devolver estatus actual de is_printer para el empleado y titular actual
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $query = sprintf(
        "SELECT is_printer AS status FROM emp_employees WHERE employee_id = %s LIMIT 1",
        GetSQLValueString($idEmpleado, "int")
    );
    $rs = mysql_query($query, $promo);
    if (!$rs) {
        http_response_code(500);
        echo json_encode(array('success' => false, 'message' => 'Error al consultar estatus' . mysql_error()));
        exit;
    }
    $row = mysql_fetch_assoc($rs);
    $status = isset($row['status']) ? intval($row['status']) : 0;
    // Buscar quién es el titular actual de la impresora
    $holder_id = null;
    $holder_alias = null;
    $qholder = "SELECT employee_id, emp_alias FROM emp_employees WHERE is_printer = 1 LIMIT 1";
    $rholder = mysql_query($qholder, $promo);
    if ($rholder) {
        $h = mysql_fetch_assoc($rholder);
        if ($h) {
            $holder_id = intval($h['employee_id']);
            $holder_alias = $h['emp_alias'];
        }
    }
    echo json_encode(array('success' => true, 'status' => $status, 'holder_id' => $holder_id, 'holder_alias' => $holder_alias));
    exit;
}

// Para otros métodos distintos a POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(array('success' => false, 'message' => 'Método no permitido'));
    exit;
}

// POST: actualizar estatus segun parametro "imprimir"
$rawImprimir = isset($_POST['imprimir']) ? $_POST['imprimir'] : null;
$imprimir = filter_var($rawImprimir, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);

if ($imprimir === null) {
    http_response_code(400);
    echo json_encode(array('success' => false, 'message' => 'Valor de "imprimir" no válido'));
    exit;
}

if ($imprimir) {

    $query = sprintf("UPDATE emp_employees SET is_printer = 0 WHERE is_printer = 1");
    if (!mysql_query($query, $promo)) {
        http_response_code(500);
        echo json_encode(array('success' => false, 'message' => 'Error al desactivar impresoras actuales'));
        exit;
    }

    $query = sprintf(
        "UPDATE emp_employees SET is_printer = 1 WHERE employee_id = %s",
        GetSQLValueString($idEmpleado, "int")
    );
    if (!mysql_query($query, $promo)) {
        http_response_code(500);
        echo json_encode(array('success' => false, 'message' => 'Error al establecer la impresora'));
        exit;
    }
    echo json_encode(array('success' => true, 'message' => 'Impresora establecida correctamente'));
} else {

    $query = sprintf(
        "UPDATE emp_employees SET is_printer = 0 WHERE employee_id = %s",
        GetSQLValueString($idEmpleado, "int")
    );
    if (!mysql_query($query, $promo)) {
        $query = sprintf("UPDATE emp_employees SET is_printer = 0 WHERE is_printer = 1");
        if (!mysql_query($query, $promo)) {
            $error = "Se intento desactivar la impresora de todos los usuarios, pero ocurrio un error";
            http_response_code(500);
            echo json_encode(array('success' => false, 'message' => 'Error al desactivar la impresora. ' . $error));
            exit;
        } else {
            http_response_code(500);
            echo json_encode(array('success' => false, 'message' => 'Error al desactivar la impresora.'));
            exit;
        }
        
    }
    echo json_encode(array('success' => true, 'message' => 'Impresora desactivada correctamente'));
}
