<?php
require_once('Connections/promo.php');

if (!isset($_SESSION)) {
  session_start();
}

if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
  {
    if (PHP_VERSION < 6) {
      if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) {
        $theValue = stripslashes($theValue);
      }
    }

    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

    switch ($theType) {
      case "text":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "long":
      case "int":
        $theValue = ($theValue != "") ? intval($theValue) : "NULL";
        break;
      case "double":
        $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
        break;
      case "date":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "defined":
        $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
        break;
    }
    return $theValue;
  }
}

$operador = $_SESSION['IDOPERADOR'];
if ($_SESSION['NIVEL'] == 1 or $_SESSION['NIVEL'] == 3) {
  $operador = '%';
}

// Consulta mesas origen
mysql_select_db($database_promo, $promo);
$query_mesas = sprintf(
    "SELECT
      H.IDORDEN,
      H.IDOPERADOR,
      E.emp_alias AS MESERO,
      H.IDSTATUS,
      H.HUESPEDES,
      COUNT(D.IDDET) AS PRODUCTOS,
      CONCAT(H.MESA, ' Productos: ', ROUND(SUM(COALESCE(D.CANT,1)),2) , ' Total: ', ROUND(SUM(COALESCE(D.CANT * D.PUNIT,0)), 2)) as MESA
    FROM
      TBL_ORDENES_PROD_HEADER H
      LEFT JOIN TBL_ORDENES_PROD_DETAIL D ON D.IDORDEN = H.IDORDEN AND D.ELIMINADO = 0
      LEFT JOIN emp_employees E ON H.IDOPERADOR = E.employee_id 
    WHERE
      H.IDSTATUS = 1 
      AND H.IDOPERADOR LIKE %s
      AND PAGADA = 0
    GROUP BY
      H.IDORDEN 
    HAVING
      PRODUCTOS > 0
    ORDER BY
      H.MESA ASC", 
    GetSQLValueString($operador, "text")
  );
$mesas = mysql_query($query_mesas, $promo) or die(mysql_error());
$row_mesas = mysql_fetch_assoc($mesas);
$totalRows_mesas = mysql_num_rows($mesas);

// Consulta mesas destino
$query_mesas2 = sprintf(
  "SELECT 
    H.IDORDEN, H.MESA, H.IDOPERADOR, E.emp_alias AS MESERO, H.IDSTATUS, H.HUESPEDES, 
    CONCAT(H.MESA, ' Productos: ', ROUND(SUM(COALESCE(D.CANT,1)),2) , ' Total: ', ROUND(SUM(COALESCE(D.CANT * D.PUNIT,0)), 2)) as MESA
  FROM 
    TBL_ORDENES_PROD_HEADER H 
    LEFT JOIN TBL_ORDENES_PROD_DETAIL D ON D.IDORDEN = H.IDORDEN AND D.ELIMINADO = 0
    LEFT JOIN emp_employees E ON H.IDOPERADOR = E.employee_id 
  WHERE H.IDSTATUS = 1 AND H.IDOPERADOR LIKE %s AND PAGADA = 0 GROUP BY H.IDORDEN ORDER BY H.MESA ASC", GetSQLValueString($operador, "text"));
$mesas2 = mysql_query($query_mesas2, $promo) or die(mysql_error());
$row_mesas2 = mysql_fetch_assoc($mesas2);
$totalRows_mesas2 = mysql_num_rows($mesas2);
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Transferir Productos</title>
  <style>
    .transpdrod2-module {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f5f5f5;
      margin: 0;
      padding: 20px;
    }

    .transpdrod2-module * {
      box-sizing: border-box;
    }

    .transpdrod2-module .container {
      max-width: 1400px;
      margin: 0 auto;
    }

    .transpdrod2-module .header {
      background: linear-gradient(135deg, #5a6c7d 0%, #4a5c6d 100%);
      color: white;
      padding: 25px;
      border-radius: 8px 8px 0 0;
      text-align: center;
    }

    .transpdrod2-module .header h1 {
      margin: 0;
      font-size: 24px;
      font-weight: 600;
    }

    .transpdrod2-module .tabs-nav {
      display: flex;
      gap: 5px;
      background: #fff;
      padding: 15px 15px 0;
      border-left: 1px solid #e0e0e0;
      border-right: 1px solid #e0e0e0;
      position: relative;
      z-index: 100;
    }

    .transpdrod2-module .tab-btn {
      padding: 12px 20px;
      border: none;
      border-radius: 6px 6px 0 0;
      cursor: pointer;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.2s;
      position: relative;
      background: #e0e0e0;
      color: #666;
      z-index: 1;
    }

    .transpdrod2-module .tab-btn:hover {
      background: #d0d0d0;
    }

    .transpdrod2-module .tab-btn.active {
      background: #5a6c7d;
      color: white;
      z-index: 2;
    }

    .transpdrod2-module .tab-content {
      background: #fff;
      padding: 25px;
      border: 1px solid #e0e0e0;
      border-radius: 0 0 8px 8px;
    }

    .transpdrod2-module .step-indicator {
      background: #f0f4f8;
      padding: 12px 18px;
      border-radius: 6px;
      margin-bottom: 20px;
      font-size: 15px;
      color: #5a6c7d;
      border-left: 4px solid #0284c7;
    }

    .transpdrod2-module .selection-row {
      display: flex;
      gap: 20px;
      margin-bottom: 25px;
    }

    .transpdrod2-module .selection-col {
      flex: 1;
    }

    .transpdrod2-module .selection-col label {
      display: block;
      margin-bottom: 8px;
      font-weight: 600;
      color: #5a6c7d;
      font-size: 14px;
    }

    .transpdrod2-module select {
      width: 100%;
      padding: 12px;
      border: 1px solid #e0e0e0;
      border-radius: 6px;
      font-size: 15px;
      background: #fff;
    }

    .transpdrod2-module select:focus {
      outline: none;
      border-color: #5a6c7d;
      box-shadow: 0 0 0 3px rgba(90, 108, 125, 0.15);
    }

    .transpdrod2-module .transfer-section {
      display: flex;
      gap: 15px;
      margin-bottom: 20px;
    }

    .transpdrod2-module .mesa-panel {
      flex: 1;
      background: #fff;
      border: 1px solid #e0e0e0;
      border-radius: 6px;
      overflow: hidden;
      box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
    }

    .transpdrod2-module .mesa-panel-header {
      background: #5a6c7d;
      color: white;
      padding: 15px;
      font-weight: 600;
      font-size: 16px;
      text-align: center;
    }

    .transpdrod2-module .mesa-panel-body {
      height: 450px;
      overflow-y: auto;
      padding: 15px;
    }

    .transpdrod2-module .btn-panel {
      width: 220px;
      display: flex;
      flex-direction: column;
      gap: 15px;
      padding-top: 60px;
      align-items: center;
    }

    .transpdrod2-module .btn-transfer {
      background: #5a6c7d;
      color: white;
      border: none;
      padding: 15px 25px;
      border-radius: 6px;
      cursor: pointer;
      font-size: 16px;
      font-weight: 600;
      transition: all 0.2s;
      box-shadow: 0 2px 6px rgba(90, 108, 125, 0.25);
      width: 100%;
      text-align: center;
    }

    .transpdrod2-module .btn-transfer:hover {
      background: #4a5c6d;
      box-shadow: 0 4px 12px rgba(90, 108, 125, 0.35);
    }

    .transpdrod2-module .btn-new-mesa {
      background: #0284c7;
      color: white;
      border: none;
      padding: 15px 25px;
      border-radius: 6px;
      cursor: pointer;
      font-size: 15px;
      font-weight: 600;
      transition: all 0.2s;
      box-shadow: 0 2px 6px rgba(2, 132, 199, 0.25);
      width: 100%;
      text-align: center;
    }

    .transpdrod2-module .btn-new-mesa:hover {
      background: #0369a1;
    }

    .transpdrod2-module .message-box {
      text-align: center;
      padding: 15px;
      margin-bottom: 20px;
      border-radius: 6px;
      font-size: 16px;
      min-height: 20px;
    }

    .transpdrod2-module .empty-state {
      text-align: center;
      color: #999;
      padding: 40px 20px;
    }

    .transpdrod2-module .empty-state svg {
      width: 48px;
      height: 48px;
      margin-bottom: 10px;
      opacity: 0.5;
    }

    .transpdrod2-module .product-item {
      background: #f9f9f9;
      padding: 12px;
      margin-bottom: 10px;
      border-radius: 6px;
      border-left: 3px solid #0284c7;
    }

    .transpdrod2-module .qty-input {
      width: 80px;
      padding: 6px;
      border: 1px solid #e0e0e0;
      border-radius: 4px;
      text-align: center;
      font-size: 14px;
      font-weight: bold;
    }

    .transpdrod2-module .product-count {
      background: #0284c7;
      color: white;
      padding: 2px 8px;
      border-radius: 10px;
      font-size: 12px;
      margin-left: 8px;
    }

    .transpdrod2-module .producto-item-huesped {
      background: #f9f9f9;
      padding: 12px;
      margin-bottom: 10px;
      border-radius: 6px;
      border-left: 3px solid #0284c7;
    }

    .transpdrod2-module .producto-nombre-huesped {
      font-weight: 600;
      margin-bottom: 8px;
      color: #333;
    }

    .transpdrod2-module .producto-botones-huesped {
      display: flex;
      flex-wrap: wrap;
      gap: 5px;
      margin-bottom: 8px;
    }

    .transpdrod2-module .producto-botones-huesped button {
      background: #5a6c7d;
      color: white;
      border: none;
      padding: 6px 12px;
      border-radius: 4px;
      cursor: pointer;
      font-size: 12px;
      transition: background 0.2s;
    }

    .transpdrod2-module .producto-botones-huesped button:hover {
      background: #0284c7;
    }

    .transpdrod2-module .producto-cantidad-info {
      font-size: 12px;
      color: #666;
    }

    .transpdrod2-module .huesped-panel {
      background: #fff;
      border: 1px solid #e0e0e0;
      border-radius: 6px;
      overflow: hidden;
    }

    .transpdrod2-module .huesped-panel-header {
      background: #0284c7;
      color: white;
      padding: 10px 15px;
      font-weight: 600;
    }

    .transpdrod2-module .huesped-panel-body {
      padding: 15px;
      min-height: 100px;
      max-height: 300px;
      overflow-y: auto;
    }
  </style>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    // Objetos para rastrear cantidades originales y restantes de cada producto
    var cantidadesOriginales = {};
    var cantidadesRestantes = {};

    function cambiarTab(tabName, button) {
      var tabs = document.getElementsByClassName('tab-content');
      for (var i = 0; i < tabs.length; i++) {
        tabs[i].style.display = 'none';
      }
      
      var botones = document.getElementsByClassName('tab-btn');
      for (var i = 0; i < botones.length; i++) {
        botones[i].classList.remove('active');
        botones[i].classList.add('inactive');
      }
      
      document.getElementById(tabName).style.display = 'block';
      button.classList.remove('inactive');
      button.classList.add('active');
    }

    function traemesaO(valor) {
      if (valor == '') {
        document.getElementById('mesao').innerHTML = '<div class="empty-state"><p>Selecciona una mesa origen</p></div>';
        document.getElementById('IDORDEN1').value = '';
        veelboton();
        return;
      }
      var partes = valor.split(',');
      var numMesa = partes[0];
      var idorden = partes[1];
      document.getElementById('IDORDEN1').value = idorden;
      veelboton();
      MuestraProductosMesa_origen(numMesa, idorden);
    }

    function traemesaD(valor) {
      if (valor == '') {
        document.getElementById('mesad').innerHTML = '<div class="empty-state"><p>Selecciona una mesa destino</p></div>';
        document.getElementById('IDORDEN2').value = '';
        veelboton();
        return;
      }
      var partes = valor.split(',');
      var numMesa = partes[0];
      var idorden = partes[1];
      document.getElementById('IDORDEN2').value = idorden;
      veelboton();
      MuestraProductosMesa_destino(numMesa, idorden);
    }

    function MuestraProductosMesa_origen(numMesa, idorden) {
      var ajax = objetoAjax();
      ajax.open('GET', 'consultaproductosT.php?IDORDEN=' + idorden + '&tm=' + Math.random());
      ajax.onreadystatechange = function() {
        if (ajax.readyState == 4) {
          document.getElementById('mesao').innerHTML = ajax.responseText;
          veelboton();
        }
      };
      ajax.send(null);
    }

    function MuestraProductosMesa_destino(numMesa, idorden) {
      var ajax = objetoAjax();
      ajax.open('GET', 'consultaproductosT2.php?IDORDEN=' + idorden + '&tm=' + Math.random());
      ajax.onreadystatechange = function() {
        if (ajax.readyState == 4) {
          document.getElementById('mesad').innerHTML = ajax.responseText;
          veelboton();
        }
      };
      ajax.send(null);
    }

    function arrsepara2Mejorado(checkbox, iddet, cantActual) {
      var ids = document.getElementById('IDPRODST').value;
      var cantidades = document.getElementById('CANTIDADES_TRANSFER');
      var cantArray = cantidades.value ? JSON.parse(cantidades.value) : {};

      if (checkbox.checked) {
        document.getElementById('IDPRODST').value = ids + ',' + iddet;
        var inputCant = document.getElementById('cant_' + iddet);
        cantArray[iddet] = inputCant ? inputCant.value : cantActual;
        cantidades.value = JSON.stringify(cantArray);
        veelboton();
      } else {
        var quita = ',' + iddet;
        document.getElementById('IDPRODST').value = ids.replace(quita, '');
        delete cantArray[iddet];
        cantidades.value = JSON.stringify(cantArray);
        veelboton();
      }
      
      actualizarConteoProductos();
    }

    function actualizaCantidadProducto(iddet, cantActual) {
      var inputCant = document.getElementById('cant_' + iddet);
      var checkbox = document.getElementById('check_' + iddet);

      if (inputCant) {
        var nuevaCant = parseFloat(inputCant.value);
        if (nuevaCant < 1) {
          inputCant.value = 1;
        } else if (nuevaCant > cantActual) {
          inputCant.value = cantActual;
        }

        if (checkbox && checkbox.checked) {
          var cantidades = document.getElementById('CANTIDADES_TRANSFER');
          var cantArray = cantidades.value ? JSON.parse(cantidades.value) : {};
          cantArray[iddet] = inputCant.value;
          cantidades.value = JSON.stringify(cantArray);
        }
      }
    }

    function actualizarConteoProductos() {
      var idprods = document.getElementById('IDPRODST').value;
      var items = idprods.split(',').filter(function(item) { return item !== '0' && item !== ''; });
      var count = items.length;
      
      var badge = document.getElementById('productos-seleccionados-count');
      if (badge) {
        if (count > 0) {
          badge.textContent = count;
          badge.style.display = 'inline-block';
        } else {
          badge.style.display = 'none';
        }
      }
    }

    function veelboton() {
      var idorden1 = document.getElementById('IDORDEN1').value;
      var idorden2 = document.getElementById('IDORDEN2').value;
      
      // Mostrar el botón si ambas mesas están seleccionadas
      if (idorden1 != '' && idorden2 != '') {
        document.getElementById('btntransf').style.display = 'block';
      } else {
        document.getElementById('btntransf').style.display = 'none';
      }
    }

    function transferirANuevaMesa() {
      if (!document.getElementById('IDORDEN1').value) {
        Swal.fire({
          icon: 'warning',
          title: 'Mesa de origen requerida',
          text: 'Por favor seleccione una mesa de origen'
        });
        return;
      }

      var idprods = document.getElementById('IDPRODST').value;
      if (idprods == '0' || idprods == '') {
        Swal.fire({
          icon: 'warning',
          title: 'Productos requeridos',
          text: 'Por favor seleccione al menos un producto para transferir'
        });
        return;
      }

      Swal.fire({
        title: 'Nueva Mesa',
        html: '<div style="margin-bottom: 15px;"><label style="display: block; margin-bottom: 5px; font-weight: 600;">Número de Mesa:</label><input type="text" id="swal-input-mesa" class="swal2-input" style="margin: 0; width: 100%;"></div>' +
              '<div><label style="display: block; margin-bottom: 5px; font-weight: 600;">Número de Huéspedes:</label><input type="number" id="swal-input-huespedes" class="swal2-input" value="1" style="margin: 0; width: 100%;"></div>',
        showCancelButton: true,
        confirmButtonText: 'Crear y Transferir',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#5a6c7d',
        preConfirm: () => {
          const mesa = document.getElementById('swal-input-mesa').value;
          const huespedes = document.getElementById('swal-input-huespedes').value;
          if (!mesa || mesa.trim() === '') {
            Swal.showValidationMessage('Por favor ingrese el número de mesa');
            return false;
          }
          return {
            mesa: mesa.trim(),
            huespedes: huespedes || '1'
          };
        }
      }).then((result) => {
        if (result.isConfirmed) {
          var numMesa = result.value.mesa;
          var huespedes = result.value.huespedes;

          var idoperador = '<?php echo $_SESSION['IDOPERADOR']; ?>';
          var idorigen = '<?php echo $_SESSION['IDORIGEN']; ?>';

          var ajax = objetoAjax();
          ajax.open('GET', 'corden.php?IDOPERADOR=' + idoperador + '&IDORIGEN=' + idorigen + '&NUM_MESA=' + numMesa + '&HUESPEDES=' + huespedes + '&TIPO=1&tm=' + Math.random());
          ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
              var nuevaOrden = ajax.responseText.trim();
              if (nuevaOrden && !isNaN(nuevaOrden)) {
                document.getElementById('IDORDEN2').value = nuevaOrden;
                var cantidades = document.getElementById('CANTIDADES_TRANSFER').value;
                ftransfiereConCantidades(document.getElementById('IDORDEN1').value, nuevaOrden, document.getElementById('IDPRODST').value, cantidades);
              } else {
                Swal.fire({
                  icon: 'error',
                  title: 'Error',
                  text: 'No se pudo crear la nueva mesa'
                });
              }
            }
          };
          ajax.send(null);
        }
      });
    }

    function ftransfiereConCantidades(v1, v2, v3, cantidades) {
      var idprods = document.getElementById('IDPRODST').value;
      if (idprods == '0' || idprods == '') {
        Swal.fire({
          icon: 'warning',
          title: 'Productos requeridos',
          text: 'Por favor seleccione al menos un producto para transferir'
        });
        return;
      }
      ActualizaTransferenciaConCantidades(v1, v2, v3, cantidades);
    }

    function ActualizaTransferenciaConCantidades(v_idorden_1, v_idorden_2, v_idprods_1, cantidades) {
      var ajax = objetoAjax();
      var url = 'acttransferencia.php?IDORDEN1=' + v_idorden_1 + '&IDORDEN2=' + v_idorden_2 + '&PRODS=' + v_idprods_1;
      if (cantidades) {
        url += '&CANTIDADES=' + encodeURIComponent(cantidades);
      }
      url += '&t=' + Math.random();

      ajax.open('GET', url);
      ajax.onreadystatechange = function() {
        if (ajax.readyState == 4) {
          let response = ajax.responseText;
          Swal.fire({
            icon: response === 'Transferencia exitosa' ? 'success' : 'info',
            title: response
          });
          if (response == 'Transferencia exitosa') {
            RefrescaMesasTransferencia(v_idorden_1, v_idorden_2);
          }
        }
      };
      ajax.send(null);
    }
    
    function RefrescaMesasTransferencia(orden_origen, orden_destino) {
      document.getElementById('IDPRODST').value = '0';
      document.getElementById('CANTIDADES_TRANSFER').value = '';
      
      var mesaOrigenSelect = document.getElementById('MESA1');
      var mesaDestinoSelect = document.getElementById('MESA2');
      
      var valorOrigen = mesaOrigenSelect.value.split(',');
      var valorDestino = mesaDestinoSelect.value.split(',');
      
      var numMesaOrigen = valorOrigen[0];
      var numMesaDestino = valorDestino[0];
      
      MuestraProductosMesa_origen(numMesaOrigen, orden_origen);
      MuestraProductosMesa_destino(numMesaDestino, orden_destino);
      
      document.getElementById('btntransf').style.display = 'none';
      
      document.getElementById('elresultado').innerHTML = '<div style="background: #d4edda; color: #155724; border: 1px solid #c3e6cb; padding: 15px; border-radius: 6px; font-weight: 600;">Transferencia realizada con éxito</div>';
      
      setTimeout(function() {
        document.getElementById('elresultado').innerHTML = '';
      }, 3000);
    }

    function cargarMesaHuesped(valor) {
      if (valor == '') {
        document.getElementById('contenedor-huesped').style.display = 'none';
        return;
      }
      
      var partes = valor.split(',');
      var idorden = partes[1];
      var huespedes = partes[2] || 1;
      
      document.getElementById('IDORDEN_HUESPED').value = idorden;
      document.getElementById('NUM_HUESPEDES').value = huespedes;
      document.getElementById('NUM_HUESPEDES_INPUT').value = huespedes;
      document.getElementById('NUM_HUESPEDES_ACTUAL').textContent = huespedes;
      document.getElementById('PRODUCTOS_HUESPED').value = '{}';
      
      cargarHuespedesYProductos(idorden, huespedes);
    }

    function cargarHuespedesYProductos(idorden, numHuespedes) {
      // Reinicializar tracking de cantidades antes de cargar productos
      cantidadesRestantes = {};
      cantidadesOriginales = {};

      var ajax = objetoAjax();
      ajax.open('GET', 'consultaproductosT.php?IDORDEN=' + idorden + '&tm=' + Math.random());
      ajax.onreadystatechange = function() {
        if (ajax.readyState == 4) {
          var htmlProductos = procesarProductosParaHuespedes(ajax.responseText, numHuespedes);
          document.getElementById('productos-origen-huesped').innerHTML = htmlProductos;
          generarPanelesHuespedes(numHuespedes);
          document.getElementById('contenedor-huesped').style.display = 'block';
        }
      };
      ajax.send(null);
    }

    function procesarProductosParaHuespedes(html, numHuespedes) {
      var temp = document.createElement('div');
      temp.innerHTML = html;

      var filas = temp.querySelectorAll('tr');
      var productosHTML = '';

      filas.forEach(function(fila) {
        var checkbox = fila.querySelector('input[type="checkbox"]');
        if (checkbox) {
          var iddet = checkbox.value;
          var selectCant = fila.querySelector('select[id^="cant_"]');
          var cantidadDisponible = selectCant ? selectCant.value : 1;

          var tdDescripcion = fila.cells[1];
          var descripcion = tdDescripcion ? tdDescripcion.textContent.trim() : '';

          // Inicializar cantidades restantes si no existen
          if (!cantidadesRestantes[iddet]) {
            cantidadesRestantes[iddet] = cantidadDisponible;
            // Guardar también la cantidad original
            if (!cantidadesOriginales[iddet]) {
              cantidadesOriginales[iddet] = parseFloat(cantidadDisponible);
            }
            console.log('[transpdrod2] init producto', {
              iddet: iddet,
              descripcion: descripcion,
              cantidadOriginal: parseFloat(cantidadDisponible),
              restante: parseFloat(cantidadesRestantes[iddet])
            });
          }

          productosHTML += '<div class="producto-item-huesped" data-iddet="' + iddet + '">' +
                          '<div class="producto-nombre-huesped">' + descripcion + '</div>' +
                          '<div class="producto-botones-huesped">';

          for (var i = 1; i <= numHuespedes; i++) {
            productosHTML += '<button type="button" onclick="agregarProductoAHuesped(' + iddet + ', \'' + descripcion.replace(/'/g, "\\'") + '\', ' + cantidadDisponible + ', ' + i + ')">Huésped ' + i + '</button>';
          }

          productosHTML += '</div>' +
                          '<div class="producto-cantidad-info">Disponible: <span class="cantidad-restante">' + cantidadDisponible + '</span></div>' +
                          '</div>';
        }
      });

      return productosHTML || '<div class="empty-state"><p>No hay productos disponibles</p></div>';
    }

    function generarPanelesHuespedes(numHuespedes) {
      var contenedor = document.getElementById('paneles-huesped');
      var html = '';
      
      for (var i = 1; i <= numHuespedes; i++) {
        html += '<div class="huesped-panel">' +
                '<div class="huesped-panel-header">Huésped ' + i + '</div>' +
                '<div class="huesped-panel-body" id="productos-huesped-' + i + '">' +
                '<div style="color: #999; text-align: center; padding: 20px;">Sin productos asignados</div>' +
                '</div>' +
                '</div>';
      }
      
      contenedor.innerHTML = html;
    }

    function actualizarNumeroHuespedes() {
      var nuevoNum = parseInt(document.getElementById('NUM_HUESPEDES_INPUT').value) || 1;
      if (nuevoNum < 1) nuevoNum = 1;
      if (nuevoNum > 20) nuevoNum = 20;
      
      document.getElementById('NUM_HUESPEDES_INPUT').value = nuevoNum;
      document.getElementById('NUM_HUESPEDES').value = nuevoNum;
      document.getElementById('NUM_HUESPEDES_ACTUAL').textContent = nuevoNum;
      
      var idorden = document.getElementById('IDORDEN_HUESPED').value;
      if (idorden) {
        document.getElementById('PRODUCTOS_HUESPED').value = '{}';
        cargarHuespedesYProductos(idorden, nuevoNum);
      }
    }

    function agregarProductoAHuesped(iddet, descripcion, cantidadDisponible, numeroHuesped) {
      var productosActuales = JSON.parse(document.getElementById('PRODUCTOS_HUESPED').value || '{}');

      if (!productosActuales['huesped_' + numeroHuesped]) {
        productosActuales['huesped_' + numeroHuesped] = {};
      }

      // Usar la cantidad restante actual (no la original) para validar
      var disponibleActual = parseFloat(cantidadesRestantes[iddet]);
      if (isNaN(disponibleActual)) {
        disponibleActual = parseFloat(cantidadDisponible);
      }

      // Si ya no hay disponible, bloquear
      if (disponibleActual <= 0) {
        Swal.fire({
          icon: 'warning',
          title: 'Sin cantidad disponible',
          text: 'Este producto ya no tiene unidades disponibles para asignar'
        });
        return;
      }

      // Generar botones de cantidad del 1 hasta disponibleActual
      var botonesHTML = '';
      var maxBotones = Math.floor(disponibleActual);
      
      if (maxBotones > 0) {
        botonesHTML = '<div style="display: flex; flex-wrap: wrap; gap: 8px; margin-top: 10px; justify-content: center;">';
        for (var btn = 1; btn <= maxBotones; btn++) {
          botonesHTML += '<button type="button" class="swal2-confirm swal2-styled cantidad-btn" data-cantidad="' + btn + '" style="margin: 0; min-width: 50px; font-size: 16px; font-weight: 600;">' + btn + '</button>';
        }
        botonesHTML += '</div>';
      }

      Swal.fire({
        title: 'Asignar a Huésped ' + numeroHuesped,
        html: '<div style="text-align: left;">' +
              '<div style="margin-bottom: 15px; padding: 10px; background: #f0f4f8; border-radius: 6px; border-left: 3px solid #0284c7;">' +
              '<div style="font-size: 12px; color: #666; margin-bottom: 5px;">Producto:</div>' +
              '<div style="font-weight: 600; color: #5a6c7d;">' + descripcion + '</div>' +
              '</div>' +
              '<label style="display: block; margin-bottom: 12px; font-weight: 600; color: #5a6c7d; font-size: 13px; text-align: center;">Seleccione cantidad a asignar:</label>' +
              botonesHTML +
              '</div>',
        showCancelButton: false,
        showConfirmButton: false,
        showCloseButton: true,
        didOpen: () => {
          // Agregar listeners a los botones de cantidad
          var botonesCantidad = document.querySelectorAll('.cantidad-btn');
          botonesCantidad.forEach(function(btn) {
            btn.addEventListener('click', function() {
              var cantidad = parseFloat(this.getAttribute('data-cantidad'));
              Swal.close();
              asignarCantidadAHuesped(iddet, descripcion, cantidad, numeroHuesped, productosActuales);
            });
          });
        }
      });
    }

    function asignarCantidadAHuesped(iddet, descripcion, cantidad, numeroHuesped, productosActuales) {

      // Acumular si ya estaba asignado a este huésped
      if (productosActuales['huesped_' + numeroHuesped][iddet]) {
        productosActuales['huesped_' + numeroHuesped][iddet].cantidad = parseFloat(productosActuales['huesped_' + numeroHuesped][iddet].cantidad) + cantidad;
      } else {
        productosActuales['huesped_' + numeroHuesped][iddet] = {
          descripcion: descripcion,
          cantidad: cantidad,
          iddet: iddet
        };
      }
      document.getElementById('PRODUCTOS_HUESPED').value = JSON.stringify(productosActuales);
      actualizarVistaHuesped(numeroHuesped, productosActuales);

      // Actualizar cantidad restante con trazas
      var restanteAntes = parseFloat(cantidadesRestantes[iddet] || 0);
      if (isNaN(restanteAntes)) restanteAntes = 0;
      var cantRestante = restanteAntes - cantidad;
      if (cantRestante < 0) cantRestante = 0; // clamp para no negativo
      cantidadesRestantes[iddet] = cantRestante;

      console.log('[transpdrod2] asignar', {
        iddet: iddet,
        descripcion: descripcion,
        asignado: cantidad,
        restanteAntes: restanteAntes,
        restanteDespues: cantRestante
      });

      // Encontrar el producto y actualizar su cantidad disponible
      var productoDiv = document.querySelector('[data-iddet="' + iddet + '"]');
      if (productoDiv) {
        var spanCantidad = productoDiv.querySelector('.cantidad-restante');
        if (spanCantidad) {
          spanCantidad.textContent = cantRestante;
        }
        // Si ya no hay cantidad disponible, remover del listado
        if (cantRestante <= 0) {
          productoDiv.remove();
          console.log('[transpdrod2] remover producto por quedarse en cero', { iddet: iddet });
        }
      }

      Swal.fire({
        icon: 'success',
        title: 'Asignado',
        text: 'Huésped ' + numeroHuesped + ' recibió ' + cantidad + ' de ' + descripcion,
        timer: 1500,
        showConfirmButton: false
      });
    }

    function removerProductoDisponible(iddet) {
      var contenedor = document.getElementById('productos-origen-huesped');
      if (!contenedor) return;
      
      var producto = contenedor.querySelector('[data-iddet="' + iddet + '"]');
      if (producto) {
        producto.remove();
      }
    }

    function actualizarVistaHuesped(numeroHuesped, productosActuales) {
      var panel = document.getElementById('productos-huesped-' + numeroHuesped);
      var html = '';
      
      if (productosActuales['huesped_' + numeroHuesped] && Object.keys(productosActuales['huesped_' + numeroHuesped]).length > 0) {
        for (var iddet in productosActuales['huesped_' + numeroHuesped]) {
          var producto = productosActuales['huesped_' + numeroHuesped][iddet];
          html += '<div style="background: #f9f9f9; padding: 10px; margin-bottom: 8px; border-radius: 4px; border-left: 3px solid #0284c7; display: flex; justify-content: space-between; align-items: center;">' +
                  '<div>' +
                  '<div style="font-weight: 600; font-size: 14px;">' + producto.descripcion + '</div>' +
                  '<div style="font-size: 12px; color: #666;">Cantidad: ' + producto.cantidad + '</div>' +
                  '</div>' +
                  '<button onclick="removerProductoHuesped(' + numeroHuesped + ', ' + iddet + ')" style="background: #ff6b6b; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">Remover</button>' +
                  '</div>';
        }
      } else {
        html = '<div style="color: #999; text-align: center; padding: 20px;">Sin productos asignados</div>';
      }
      
      panel.innerHTML = html;
    }
    
    function removerProductoHuesped(numeroHuesped, iddet) {
      var productosActuales = JSON.parse(document.getElementById('PRODUCTOS_HUESPED').value || '{}');
      
      if (productosActuales['huesped_' + numeroHuesped] && productosActuales['huesped_' + numeroHuesped][iddet]) {
        var cantidadQueSeQuita = productosActuales['huesped_' + numeroHuesped][iddet].cantidad;
        delete productosActuales['huesped_' + numeroHuesped][iddet];
        document.getElementById('PRODUCTOS_HUESPED').value = JSON.stringify(productosActuales);
        actualizarVistaHuesped(numeroHuesped, productosActuales);
        
        console.log('[transpdrod2] remover de huesped', {
          huesped: numeroHuesped,
          iddet: iddet,
          cantidadDevuelta: cantidadQueSeQuita,
          restanteAntes: parseFloat(cantidadesRestantes[iddet] || 0)
        });

        // Restaurar la cantidad al pool de disponibles
        restaurarProductoDisponible(iddet, cantidadQueSeQuita);
      }
    }

    function restaurarProductoDisponible(iddet, cantidadQueSeQuita) {
      var contenedor = document.getElementById('productos-origen-huesped');
      
      // Buscar si el producto existe en el DOM
      var productoExistente = contenedor.querySelector('[data-iddet="' + iddet + '"]');
      
      if (productoExistente) {
        // Si existe, aumentar la cantidad disponible
        var spanCantidad = productoExistente.querySelector('.cantidad-restante');
        if (spanCantidad) {
          var cantActual = parseFloat(spanCantidad.textContent);
          var nuevaCant = cantActual + cantidadQueSeQuita;
          spanCantidad.textContent = nuevaCant;
          cantidadesRestantes[iddet] = nuevaCant;
            console.log('[transpdrod2] restaurar existente', {
              iddet: iddet,
              cantidadDevuelta: cantidadQueSeQuita,
              cantActual: cantActual,
              nuevaCant: nuevaCant
            });
        }
      } else {
        // Si no existe, buscarlo en el servidor y recrearlo
        var ajax = objetoAjax();
        var idorden = document.getElementById('IDORDEN_HUESPED').value;
        ajax.open('GET', 'consultaproductosT.php?IDORDEN=' + idorden + '&tm=' + Math.random());
        ajax.onreadystatechange = function() {
          if (ajax.readyState == 4) {
            var temp = document.createElement('div');
            temp.innerHTML = ajax.responseText;
            var filas = temp.querySelectorAll('tr');
            
            filas.forEach(function(fila) {
              var checkbox = fila.querySelector('input[type="checkbox"]');
              if (checkbox && checkbox.value == iddet) {
                var selectCant = fila.querySelector('select[id^="cant_"]');
                var cantidadDisponible = selectCant ? selectCant.value : 1;
                var tdDescripcion = fila.cells[1];
                var descripcion = tdDescripcion ? tdDescripcion.textContent.trim() : '';
                
                // Restaurar cantidad restante
                var nuevaCant = parseFloat(cantidadesRestantes[iddet] || 0) + cantidadQueSeQuita;
                // Usar la cantidad original si existe
                var cantidadOriginal = cantidadesOriginales[iddet] || parseFloat(cantidadDisponible);
                cantidadesRestantes[iddet] = nuevaCant;
                
                // Crear HTML del producto restaurado
                var numHuespedes = parseInt(document.getElementById('NUM_HUESPEDES').value);
                var productosHTML = '<div class="producto-item-huesped" data-iddet="' + iddet + '">' +
                                   '<div class="producto-nombre-huesped">' + descripcion + '</div>' +
                                   '<div class="producto-botones-huesped">';
                
                for (var i = 1; i <= numHuespedes; i++) {
                  productosHTML += '<button type="button" onclick="agregarProductoAHuesped(' + iddet + ', \'' + descripcion.replace(/'/g, "\\'") + '\', ' + cantidadDisponible + ', ' + i + ')">Huésped ' + i + '</button>';
                }
                
                productosHTML += '</div>' +
                               '<div class="producto-cantidad-info">Disponible: <span class="cantidad-restante">' + nuevaCant + '</span></div>' +
                               '</div>';
                
                // Agregar al contenedor
                contenedor.innerHTML += productosHTML;

                console.log('[transpdrod2] restaurar nuevo', {
                  iddet: iddet,
                  descripcion: descripcion,
                  cantidadDevuelta: cantidadQueSeQuita,
                  nuevaCant: nuevaCant,
                  cantidadOriginal: cantidadOriginal
                });
                return;
              }
            });
          }
        };
        ajax.send(null);
      }
    }
    
    function crearMesasParaHuespedes() {
      var idordenOrigen = document.getElementById('IDORDEN_HUESPED').value;
      var numHuespedes = document.getElementById('NUM_HUESPEDES').value;
      var productosHuesped = document.getElementById('PRODUCTOS_HUESPED').value;
      
      if (idordenOrigen == 0 || !idordenOrigen) {
        Swal.fire({
          icon: 'warning',
          title: 'Error',
          text: 'Por favor seleccione una mesa'
        });
        return;
      }
      
      var productosTiene = JSON.parse(productosHuesped);
      var conProductos = false;
      for (var key in productosTiene) {
        if (Object.keys(productosTiene[key]).length > 0) {
          conProductos = true;
          break;
        }
      }
      
      if (!conProductos) {
        Swal.fire({
          icon: 'warning',
          title: 'Error',
          text: 'Asigne al menos un producto a algún huésped'
        });
        return;
      }
      
      var idoperador = '<?php echo $_SESSION['IDOPERADOR']; ?>';
      var idorigen = '<?php echo $_SESSION['IDORIGEN']; ?>';
      
      Swal.fire({
        title: 'Procesando...',
        text: 'Creando mesas para huéspedes',
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });
      
      var ajax = objetoAjax();
      var url = 'divisiontransferenciahuesped.php?IDORDEN_ORIGEN=' + idordenOrigen + '&PRODUCTOS=' + encodeURIComponent(productosHuesped) + '&IDOPERADOR=' + idoperador + '&IDORIGEN=' + idorigen + '&t=' + Math.random();
      
      ajax.open('GET', url);
      ajax.onreadystatechange = function() {
        if (ajax.readyState == 4) {
          var response = ajax.responseText.trim();
          if (response === 'Exito') {
            Swal.fire({
              icon: 'success',
              title: 'Mesas creadas',
              text: 'Se han creado las mesas para cada huésped correctamente'
            });
            
            document.getElementById('MESA_HUESPED').value = '';
            document.getElementById('PRODUCTOS_HUESPED').value = '{}';
            document.getElementById('contenedor-huesped').style.display = 'none';
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error',
              text: response
            });
          }
        }
      };
      ajax.send(null);
    }
  </script>
</head>

<body>
  <div class="transpdrod2-module">
    <div class="container">
      <div class="header">
        <h1>Transferir Productos Entre Mesas</h1>
      </div>
      
      <div class="tabs-nav">
        <button class="tab-btn active" onclick="cambiarTab('tab-transferencia', this)">Transferencia Entre Mesas</button>
        <button class="tab-btn inactive" onclick="cambiarTab('tab-huesped', this)">Transferencia Por Huésped</button>
      </div>
      
      <div id="tab-transferencia" class="tab-content" style="display: block;">
        <div class="step-indicator">
          <strong>Paso 1:</strong> Selecciona una mesa de origen y una de destino
        </div>

        <div class="selection-row">
          <div class="selection-col">
            <label>Mesa Origen:</label>
            <?php if ($totalRows_mesas > 0) {
              mysql_data_seek($mesas, 0); ?>
              <select name="MESA1" id="MESA1" onchange="traemesaO(this.value)">
                <option value="">-- Seleccione una mesa --</option>
                <?php while ($row_mesas = mysql_fetch_assoc($mesas)) { ?>
                  <option value="<?php echo $row_mesas['MESA']; ?>,<?php echo $row_mesas['IDORDEN']; ?>">
                    Mesa <?php echo $row_mesas['MESA']; ?> - <?php echo $row_mesas['MESERO']; ?>
                  </option>
                <?php } ?>
              </select>
            <?php } else { ?>
              <p style="color: #999; padding: 20px; text-align: center;">No hay mesas disponibles</p>
            <?php } ?>
          </div>

          <div class="selection-col">
            <label>Mesa Destino:</label>
            <?php if ($totalRows_mesas2 > 0) {
              mysql_data_seek($mesas2, 0); ?>
              <select name="MESA2" id="MESA2" onchange="traemesaD(this.value)">
                <option value="">-- Seleccione una mesa --</option>
                <?php while ($row_mesas2 = mysql_fetch_assoc($mesas2)) { ?>
                  <option value="<?php echo $row_mesas2['MESA']; ?>,<?php echo $row_mesas2['IDORDEN']; ?>">
                    Mesa <?php echo $row_mesas2['MESA']; ?> - <?php echo $row_mesas2['MESERO']; ?>
                  </option>
                <?php } ?>
              </select>
            <?php } else { ?>
              <p style="color: #999; padding: 20px; text-align: center;">No hay mesas disponibles</p>
            <?php } ?>
          </div>
        </div>

        <div class="step-indicator">
          <strong>Paso 2:</strong> Selecciona los productos para transferir
        </div>

        <input type="hidden" name="IDORDEN1" id="IDORDEN1" />
        <input type="hidden" name="IDORDEN2" id="IDORDEN2" />
        <input name="IDPRODST" type="hidden" id="IDPRODST" value="0" />
        <input name="CANTIDADES_TRANSFER" type="hidden" id="CANTIDADES_TRANSFER" value="" />

        <div id="elresultado" class="message-box"></div>

        <div class="transfer-section">
          <div class="mesa-panel">
            <div class="mesa-panel-header">Productos de Mesa Origen <span class="product-count" id="productos-seleccionados-count" style="display: none;">0</span></div>
            <div class="mesa-panel-body" id="mesao">
              <div class="empty-state"><p>Selecciona una mesa origen</p></div>
            </div>
          </div>

          <div class="btn-panel">
            <button id="btntransf" style="display:none;" class="btn-transfer" onclick="ftransfiereConCantidades(document.getElementById('IDORDEN1').value,document.getElementById('IDORDEN2').value,document.getElementById('IDPRODST').value,document.getElementById('CANTIDADES_TRANSFER').value)">Transferir Productos →</button>
            <button class="btn-new-mesa" onclick="transferirANuevaMesa()">+ Crear Nueva Mesa</button>
          </div>

          <div class="mesa-panel">
            <div class="mesa-panel-header">Productos de Mesa Destino</div>
            <div class="mesa-panel-body" id="mesad">
              <div class="empty-state"><p>Selecciona una mesa destino</p></div>
            </div>
          </div>
        </div>
      </div>
      
      <div id="tab-huesped" class="tab-content" style="display: none;">
        <div class="step-indicator">
          <strong>Paso 1:</strong> Selecciona la mesa con los huéspedes
        </div>

        <div class="selection-row">
          <div class="selection-col">
            <label>Mesa:</label>
            <?php 
            mysql_data_seek($mesas, 0);
            if ($totalRows_mesas > 0) { ?>
              <select name="MESA_HUESPED" id="MESA_HUESPED" onchange="cargarMesaHuesped(this.value)">
                <option value="">-- Seleccione una mesa --</option>
                <?php while ($row_mesas_h = mysql_fetch_assoc($mesas)) { ?>
                  <option value="<?php echo $row_mesas_h['MESA']; ?>,<?php echo $row_mesas_h['IDORDEN']; ?>,<?php echo isset($row_mesas_h['HUESPEDES']) ? $row_mesas_h['HUESPEDES'] : 1; ?>">
                    Mesa <?php echo $row_mesas_h['MESA']; ?> - <?php echo $row_mesas_h['MESERO']; ?>
                  </option>
                <?php } ?>
              </select>
            <?php } else { ?>
              <p style="color: #999; padding: 20px; text-align: center;">No hay mesas disponibles</p>
            <?php } ?>
          </div>
        </div>

        <input type="hidden" id="IDORDEN_HUESPED" value="0" />
        <input type="hidden" id="NUM_HUESPEDES" value="1" />
        <input type="hidden" id="PRODUCTOS_HUESPED" value="{}" />

        <div id="contenedor-huesped" style="display: none;">
          <div class="step-indicator">
            <strong>Paso 2:</strong> Define el número de huéspedes
          </div>
          
          <div style="margin-bottom: 20px; background: #f0f4f8; padding: 15px; border-radius: 6px;">
            <label style="display: block; font-weight: 600; margin-bottom: 10px; color: #5a6c7d; font-size: 14px;">Número de Huéspedes:</label>
            <div style="display: flex; gap: 10px; align-items: center;">
              <input type="number" id="NUM_HUESPEDES_INPUT" class="qty-input" min="1" max="20" value="1" onchange="actualizarNumeroHuespedes()" style="width: 120px; padding: 10px; font-size: 16px; font-weight: 600;">
              <span style="color: #666; font-size: 14px;">(Actual: <strong id="NUM_HUESPEDES_ACTUAL">1</strong>)</span>
            </div>
          </div>

          <div class="step-indicator">
            <strong>Paso 3:</strong> Asigna productos a cada huésped
          </div>
          
          <div class="transfer-section">
            <div class="mesa-panel">
              <div class="mesa-panel-header">Productos de la Mesa</div>
              <div class="mesa-panel-body" id="productos-origen-huesped">
                <div class="empty-state"><p>Cargando productos...</p></div>
              </div>
            </div>
            
            <div style="flex: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 15px; overflow-y: auto; max-height: 500px;" id="paneles-huesped"></div>
          </div>
          
          <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #e0e0e0;">
            <button class="btn-new-mesa" onclick="crearMesasParaHuespedes()" style="background: #0284c7; width: auto; padding: 15px 40px; font-size: 16px;">Crear Mesas para Huéspedes</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>

</html>
<?php
mysql_free_result($mesas);
mysql_free_result($mesas2);
?>
