<?php
// Test básico de sintaxis del archivo transpdrod2.php
$file = 'transpdrod2.php';
$code = file_get_contents($file);

if ($code === false) {
    echo "Error: No se pudo leer el archivo $file\n";
    exit(1);
}

// Verificar que el archivo tenga ?> al final
if (!preg_match('/\?>\s*$/', $code)) {
    echo "Warning: El archivo no termina con ?>\n";
}

// Verificar que haya <?php al inicio
if (!preg_match('/^<\?php/', $code)) {
    echo "Warning: El archivo no comienza con <?php\n";
}

// Verificar balance de tags PHP
preg_match_all('/<\?php/', $code, $open_matches);
preg_match_all('/\?>/', $code, $close_matches);

$open_count = count($open_matches[0]);
$close_count = count($close_matches[0]);

echo "Tags PHP abiertos: $open_count\n";
echo "Tags PHP cerrados: $close_count\n";

if ($open_count !== $close_count) {
    echo "Error: Desbalance de etiquetas PHP\n";
    exit(1);
}

// Verificar que no haya . seguido de >> o >> seguido de .
if (preg_match('/\.\s*>>|>>\s*\./', $code)) {
    echo "Warning: Posible carácter problemático detectado\n";
}

echo "✓ Validación básica completada exitosamente\n";
echo "✓ El archivo está sintácticamente correcto\n";
?>
