<?php
// Allow requests from specific origin (replace with your actual origin)
header("Access-Control-Allow-Origin: *");

// Allow specific headers including Authorization
header("Access-Control-Allow-Headers: Authorization, Content-Type");

// Allow all HTTP methods
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    // Return response for preflight request
    header("HTTP/1.1 200 OK");
    exit;
}

//por defecto contesta con un código 500
http_response_code(500);

require_once(__DIR__ . '/../../Connections/promo.php');
error_reporting(E_ERROR);

require_once(__DIR__ . '/includes/JsonSchema/Autoloader.php');
require_once(__DIR__ . '/includes/ValidatorXnet.php');
require_once(__DIR__ . '/includes/functions.php');
require_once(__DIR__ . '/includes/mysqlx.php');
require_once(__DIR__ . '/includes/exceptions.php');
require_once(__DIR__ . '/router.php');
require_once(__DIR__ . '/response.php');

mysqlx::$connection = $promo;
mysqlx::$dataBase = $database_promo;
// ##################################################
// ##################################################
// ##################################################
try {
    require_once(__DIR__ . '/includes/access_log.php');
    require_once(__DIR__ . '/includes/autorization.php');
    // ##################################################
    // Inicializo
    // ##################################################

    // ##################################################
    // Start Routes
    // ##################################################
    post('/stores/$storeUUID/orders/$orderIdWeb/mark-ready', 'endpoints/setReadyOrder.php');
    // ##################################################
    // Respuesta por default
    // ##################################################
    any('/404', function () {
        throw new MethodException();
    });
} catch (MethodException $a) {
    solve(RESPONSE_404, [
        'error' => [
            "message" => 'Method not allowed. The method specified in the Request-Line is not allowed for the resource identified by the Request-URI.',
            "type" => 'OAuthException',
            "code" => -1,
            "error_subcode" => 0
        ]
    ]);
} catch (CustomException $a) {
    solve(RESPONSE_400, [
        'error' => [
            "message" => $a->getMessage(),
            "type" => $a->getType(),
            "code" => $a->getCode(),
            "error_subcode" => $a->getSubCode(),
            "details" => $a->getDetails()
        ]
    ]);
} catch (ArgumentsException $a) {
    solve(RESPONSE_400, [
        'error' => [
            "message" => $a->getMessage(),
            "type" => $a->getType(),
            "code" => $a->getCode(),
            "error_subcode" => $a->getSubCode()
        ]
    ]);
} catch (OAuthException $a) {
    solve(RESPONSE_401, [
        'error' => [
            "message" => $a->getMessage(),
            "type" => $a->getType(),
            "code" => $a->getCode(),
            "error_subcode" => $a->getSubCode()
        ]
    ]);
} catch (AuthException $a) {
    solve(RESPONSE_403, [
        'error' => [
            "message" => $a->getMessage(),
            "type" => $a->getType(),
            "code" => $a->getCode(),
            "error_subcode" => $a->getSubCode()
        ]
    ]);
} catch (\Throwable $th) {
    solve(RESPONSE_500, [
        'error' => [
            'message' => $th->getMessage(),
            'type' => UNHANDLED_EXCEPTION,
            'code' => 0,
            "error_subcode" => $th->getCode(),
            "details" => [
                [
                    "file" => substr($th->getFile(), strpos($th->getFile(), $_GLOBAL['router_base'])),
                    "line" => $th->getLine()
                ]
            ]
        ]
    ]);
}
