<?php
define('RESPONSE_200', '200');
define('RESPONSE_201', '201');
define('RESPONSE_204', '204');
define('RESPONSE_400', '400');
define('RESPONSE_401', '401');
define('RESPONSE_402', '402');
define('RESPONSE_403', '403');
define('RESPONSE_404', '404');
define('RESPONSE_405', '405');
define('RESPONSE_500', '500');

function solve($http_code, $response = [], $exit = false)
{
	header('Content-Type: application/json');
	http_response_code(intval($http_code));
	$response = json_encode($response);

	if ($response === false) {
		$errorCode = json_last_error();
		$errorMessage = json_last_error_msg();
		http_response_code(intval(RESPONSE_400));
		echo json_encode([
			'error' => [
				'message' => $errorMessage,
				'type' => UNHANDLED_EXCEPTION,
				'code' => 0,
				"error_subcode" => $errorCode
			]
		]);
		return;
	}

	echo $response;

	if ($exit) {
		exit;
	}
}
