<?php
define("ARGUMENT_EXCEPTION", "ArgumentException");
define("PARAMETER_EXCEPTION", "ParameterException");
define("UNEXPECTED_EXCEPTION", "UnexpectedException");
define("OAUTH_EXCEPTION", "OAuthException");
define("AUTH_EXCEPTION", "AuthException");
define("UNHANDLED_EXCEPTION", "UnhandledException");
define("BODY_EXCEPTION", "BodyException");

/**
 * Esta es la clase principal de todas las excepciones
 */
abstract class MasterException extends \Exception
{
    /**
     * Detalles
     *
     * @var array
     */
    protected $details;

    /**
     * Tipo de excepción
     *
     * @var string
     */
    protected $type;

    /**
     * Subcódigo de error
     *
     * @var integer
     */
    protected $subcode;

    /**
     * Constructor
     *
     * @param string $message
     * @param integer $code
     */
    public function __construct($message, $code = 0)
    {
        parent::__construct($message, $code);
    }

    /**
     * Establece detalles en la excepción
     *
     * @param array $details
     * @return void
     */
    public function setDetails($details)
    {
        $this->details = $details;
    }

    /**
     * Obtiene los detalles de la excepción
     *
     * @return array
     */
    public function getDetails()
    {
        return $this->details;
    }

    /**
     * Obtiene el tipo de excepción
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Obtiene el subcódigo de excepción
     *
     * @return integer
     */
    public function getSubCode()
    {
        return $this->subcode;
    }

    /**
     * Establece el subcódigo de excepción
     *
     * @param integer $subcode
     * @return void
     */
    public function setSubCode($subcode)
    {
        $this->subcode = $subcode;
    }

    /**
     * Establece el tipo de excepción
     *
     * @param string $type
     * @return void
     */
    public function setType($type)
    {
        $this->type = $type;
    }
}

class MethodException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0)
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
    }
}

class OAuthException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0)
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
    }
}

class AuthException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0)
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
    }
}

class loginException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0)
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
    }
}

class ArgumentsException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0)
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
    }
}

class CustomException extends MasterException
{
    public function __construct($message = '', $type = '', $code = 0, $subcode = 0, $details = [])
    {
        parent::__construct($message, $code);
        $this->setType($type);
        $this->setSubCode($subcode);
        $this->setDetails($details);
    }
}
