<?php

use JsonSchema\ConstraintError;
use JsonSchema\Exception\ValidationException;
use JsonSchema\SchemaStorage;
use JsonSchema\Validator;

class ValidatorXnet extends Validator
{
    /**
     * Estructura de entrada
     *
     * @var array
     */
    protected $input;

    /**
     * Valida la estructura
     *
     * @param array $value
     * @param array $schema
     * @param boolean $checkMode
     * @return void
     */
    public function verify($value, $schema = null, $checkMode = null)
    {
        $this->input = $value;

        if (is_array($value)) {
            $value = json_decode(json_encode($value));
        }

        parent::validate($value, $schema, $checkMode);
    }

    /**
     * Añade un error customizado
     *
     * @param string $error
     * @return void
     */
    public function includeError($error, $property = '')
    {
        $this->addErrors([
            [
                'property' => $property,
                'message' => $error
            ]
        ]);
    }

    /**
     * Devuelve el error capturado
     *
     * @return string|null
     */
    public function getError()
    {
        @$error = $this->getErrors()[0];
        if ($error) {
            return (!empty($error['property']) ? '[' . $error['property'] . '] ' : '') . $error['message'];
        }
        return null;
    }
}
