<?php
// Este archivo imprime el JS del servicio de impresión y sincronización de cookie/flag
?>
<script>
  // ID del empleado actual disponible para la lógica del cliente
  const CURRENT_EMPLOYEE_ID = <?php echo (int)$_SESSION["IDOPERADOR"]; ?>;

  function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
    return null;
  }

  function setCookieImprime(valor) {
    const btn = document.getElementById('btnImprimeToggle');
    const activo = (valor === 1 || valor === '1' || valor === true);

    if (activo) {
      document.cookie = "IMPRIME=1; path=/; SameSite=Lax";
      if (btn) {
        btn.style.backgroundColor = 'lightgreen';
        btn.textContent = 'Activo';
        btn.setAttribute('onclick', 'toggleCookieImprime(false)');
      }
    } else {
      document.cookie = "IMPRIME=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/; SameSite=Lax";
      if (btn) {
        btn.style.backgroundColor = 'tomato';
        btn.textContent = 'Apagado';
        btn.setAttribute('onclick', 'toggleCookieImprime(true)');
      }
    }
  }

  let __lastImprime = getCookie('IMPRIME') === '1' ? 1 : 0;
  let __suppressLostAlertUntil = 0;
  function suppressLostAlert(ms) { __suppressLostAlertUntil = Date.now() + (ms || 3000); }
  function lostAlertSuppressed() { return Date.now() <= __suppressLostAlertUntil; }

  // Servicio de impresión dinámico (inicia/detiene sin recargar)
  var buscandoImprimir = false;
  var imprimirIntervalId = null;

  function doBuscarImprimir() {
    $.ajax({
      type: "GET",
      url: "buscarImprimir.php",
      beforeSend: function () { buscandoImprimir = true; },
      success: function (data) {
        try { data = (typeof data === 'string') ? JSON.parse(data) : data; } catch (e) { data = {}; }
        if (data && data.success) {
          let idorden = data.ordenes.idorden;
          let tipo = data.ordenes.tipo;
          let digital = data.ordenes.digital;
          if (tipo == 'IMPN') {
            printTicketVentaNoCerrado(idorden);
            if (digital == 1) { setTimeout(() => { printTicketVentaNoCerrado(idorden); }, 1000); }
          }
          if (tipo == 'IMPR') { reprintTicket(idorden); }
          if (tipo == 'CORTE') { printTicketCorte(idorden); }
          if (tipo == 'CANCELACION') { printTicketCancelacion(idorden); }
          if (tipo == 'RECOLECCION') { printTicketRecoleccionEfectivo(idorden); }
          if (tipo == 'PROPINA') { printTicketPropinas(idorden); }
          if (tipo == 'PAGO_ELIMINADO') { printTicketPagoEliminado(idorden); }
        }
      },
      error: function () {},
      complete: function () { buscandoImprimir = false; }
    });
  }

  function printerTick() {
    let ticketEl = document.getElementById('TICKET');
    let ticket = ticketEl ? ticketEl.value : null;
    if (ticket === "" || ticket === undefined || ticket === null || true) {
      if (buscandoImprimir) return;

      // Verifica en cada petición si aún tienes la impresora activa
      $.ajax({
        type: "GET",
        url: "verificar_impresora.php",
        dataType: 'json',
        success: function (statusData) {
          const activo = statusData && statusData.success === true && parseInt(statusData.status, 10) === 1;
          if (!activo) {
            setCookieImprime(0);
            suppressLostAlert(3000);
            stopPrinterService();
            __lastImprime = 0;
            return;
          }
          // Si sigue activo, proceder a buscar impresiones
          doBuscarImprimir();
        },
        error: function () {
          // Si falla la verificación, se detiene para no imprimir sin control
          stopPrinterService();
        }
      });
    }
  }

  function startPrinterService() {
    if (imprimirIntervalId !== null) return; // ya corriendo
    imprimirIntervalId = setInterval(printerTick, 2000);
    // printerTick(); // si se desea ejecución inmediata
  }

  function stopPrinterService() {
    if (imprimirIntervalId !== null) {
      clearInterval(imprimirIntervalId);
      imprimirIntervalId = null;
    }
  }

  function checkImprimeStatus() {
    $.ajax({
      type: "GET",
      url: "verificar_impresora.php",
      dataType: 'json',
      success: function (data) {
        if (data && data.success === true && typeof data.status !== 'undefined') {
          const nuevo = parseInt(data.status, 10) === 1 ? 1 : 0;
          if (nuevo !== __lastImprime) {
            setCookieImprime(nuevo);
            if (nuevo === 1) {
              startPrinterService();
            } else {
              // Si se perdió el control, avisar si otro usuario lo tomó
              stopPrinterService();
              const holderId = data.holder_id || null;
              const holderAlias = data.holder_alias || '';
              if (__lastImprime === 1 && nuevo === 0 && !lostAlertSuppressed()) {
                if (holderId && holderId !== CURRENT_EMPLOYEE_ID) {
                  Swal.fire({
                    icon: 'info',
                    title: 'Control de impresora cambiado',
                    html: 'Otro usuario tomó el control de la impresora: <b>' + holderAlias + '</b>',
                    timer: 4000,
                    showConfirmButton: false
                  });
                } else {
                  Swal.fire({
                    icon: 'info',
                    title: 'Impresión desactivada',
                    text: 'Perdiste el control de la impresora.',
                    timer: 3000,
                    showConfirmButton: false
                  });
                }
              }
            }
            __lastImprime = nuevo;
            return;
          }
          // sin cambios, solo asegura UI/cookie correcta
          setCookieImprime(nuevo);
          if (nuevo === 1) { startPrinterService(); } else { stopPrinterService(); }
          __lastImprime = nuevo;
        }
      },
      error: function () {
        // en error no modificamos el estado
      }
    });
  }

  // Arranque y sincronización periódica
  checkImprimeStatus();
  setInterval(checkImprimeStatus, 10000);
  if (__lastImprime === 1) { startPrinterService(); } else { stopPrinterService(); }

  // Toggle desde el botón del header
  function toggleCookieImprime(activo) {
    $.ajax({
      type: "POST",
      url: "verificar_impresora.php",
      data: { imprimir: activo },
      dataType: 'json',
      success: function(data) {
        if (data && data.success === true) {
          const nuevo = (activo ? 1 : 0);
          setCookieImprime(nuevo);
          if (nuevo === 1) {
            startPrinterService();
          } else {
            // si fue acción local para apagar, evita alerta inmediata del poll
            suppressLostAlert(5000);
            stopPrinterService();
          }
          __lastImprime = nuevo;
        }
      },
      error: function() {
        setCookieImprime(0);
      }
    });
  }
</script>
