// Utilidades para desactivar y reactivar elementos clicables
function getClickableElements() {
  return Array.from(document.querySelectorAll("button, a, [onclick]"));
}

function disableClickableElements() {
  const elements = getClickableElements();
  elements.forEach((el) => {
    el._wasDisabled = el.disabled || el.classList.contains("disabled");
    el.disabled = true;
    el.classList.add("disabled");
    el.style.pointerEvents = "none";
    el.style.opacity = "0.6";
  });
}

function enableClickableElements() {
  const elements = getClickableElements();
  elements.forEach((el) => {
    if (!el._wasDisabled) {
      el.disabled = false;
      el.classList.remove("disabled");
      el.style.pointerEvents = "";
      el.style.opacity = "";
    }
    delete el._wasDisabled;
  });
}

const TIMEOUT_LIMIT = 2000; // 5 segundos
const TARGET_ENDPOINT = "agregar"; // Cambia según tu endpoint

// jQuery AJAX interceptor
$(document).ajaxSend(function (event, jqxhr, settings) {
  if (settings.url.includes(TARGET_ENDPOINT)) {
    disableClickableElements();

    const timeoutId = setTimeout(() => {
      Swal.fire({
        icon: "warning",
        title: "Agregando producto",
        text: `Por favor, espera a que el producto se agregue a la orden`,
        timer: 4000,
        timerProgressBar: true,
        showConfirmButton: false,
      });
    }, TIMEOUT_LIMIT);

    jqxhr.always(function () {
      clearTimeout(timeoutId);
      enableClickableElements();
    });
  }
});

// XMLHttpRequest interceptor (para objetoAjax u otros)
(function () {
  const originalOpen = XMLHttpRequest.prototype.open;
  const originalSend = XMLHttpRequest.prototype.send;

  XMLHttpRequest.prototype.open = function (method, url, ...rest) {
    this._requestUrl = url;
    return originalOpen.call(this, method, url, ...rest);
  };

  XMLHttpRequest.prototype.send = function (body) {
    if (this._requestUrl.includes(TARGET_ENDPOINT)) {
      const xhr = this;
      disableClickableElements();

      const timeoutId = setTimeout(() => {
        Swal.fire({
          icon: "warning",
          title: "Agregando producto",
          text: `Por favor, espera a que el producto se agregue a la orden`,
          timer: 4000,
          timerProgressBar: true,
          showConfirmButton: false,
        });
      }, TIMEOUT_LIMIT);

      this.addEventListener("loadend", function () {
        clearTimeout(timeoutId);
        enableClickableElements();
      });
    }

    return originalSend.call(this, body);
  };
})();

function objetoAjax() {
  //llaada ajac ppal
  var xmlhttp = false;
  try {
    xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
  } catch (e) {
    try {
      xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (E) {
      xmlhttp = false;
    }
  }

  if (!xmlhttp && typeof XMLHttpRequest != "undefined") {
    xmlhttp = new XMLHttpRequest();
  }
  return xmlhttp;
}

function GuardaProducto(datos) {
  //guarda producto principal en ticket

  ajax = objetoAjax();
  ajax.open("GET", datos);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      MuestraProductos("consultaproductos.php?IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random());
      const params = new URLSearchParams(datos.split("?")[1]);
      console.log(params);
      // jQuery("#ctr").load("mpflow4.php?ID="+params.get('idsubmenu')+'&ANT='+params.get('anterior')+'&TM='+Math.random());
    }
  };
  ajax.send(null);
}

function GuardaOpcion(dats) {
  //guada opcion seleccionada

  ajax = objetoAjax();
  ajax.open("GET", dats);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      MuestraProductos("consultaproductos.php?IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random());
      const params = new URLSearchParams(dats.split("?")[1]);
      if (params.get("nv2") > 0 && params.get("posicion") != "") {
        jQuery("#ctr").load("mpflow4.php?ID=" + params.get("anterior") + "&ANT=" + params.get("anterior") + "&POSICION=" + params.get("posicion") + "&TM=" + Math.random());
      }
      if (params.get("posicion") == "") {
        //no hay mas opcion limpiar
        jQuery("#ctr").load("blank.php");
      }
    }
  };
  ajax.send(null);
}

function NuevaOrden(ins, iduser, num_mesa, huespedes, tipo) {
  //cra nueva orden

  ajax = objetoAjax();
  ajax.open("GET", ins);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      //alert(ajax.responseText);
      document.getElementById("norden").innerHTML = ajax.responseText;
      document.getElementById("MESA").innerHTML = num_mesa;
      document.getElementById("HUESP").innerHTML = huespedes;
      document.getElementById("btnhuespedes").style.display = "";
      document.getElementById("btnmesa").style.display = "";
      document.getElementById("HUESPEDESV").value = huespedes;
      document.getElementById("TICKET").value = ajax.responseText;
      document.getElementById("TSERV").value = tipo; //tipo de servicio 1 dine inn 2 togo

      //pone comensales
      MuestraProductos("consultaproductos.php?USER=" + iduser + "&IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random());
      ppal();
      document.getElementById("cerrar").click();
    }
  };
  ajax.send(null);
}

function traemesa(ins, num_mesa, iduser, mesero, lafecha, actpago) {
  //trae  orden abierta
  try {
    divResultado = document.getElementById("ENVI");
    divResultado.innerHTML = "";

    Swal.fire({
      title: "Cargando...",
      text: "Por favor espera un momento",
      allowOutsideClick: false,
      allowEscapeKey: false,
      didOpen: () => {
        Swal.showLoading();
      },
    });

    ajax = objetoAjax();
    ajax.open("GET", ins + "&m=" + Math.random());
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        resu = ajax.responseText;
        v1 = resu.split("|");

        //alert(ajax.responseText);
        document.getElementById("norden").innerHTML = v1[0];
        document.getElementById("MESA").innerHTML = v1[3];
        document.getElementById("HUESP").innerHTML = v1[1];
        document.getElementById("btnhuespedes").style.display = "";
        document.getElementById("btnmesa").style.display = "";
        document.getElementById("ELMESERO").innerHTML = mesero;
        document.getElementById("FECHACOLOCADA").innerHTML = lafecha;
        document.getElementById("HUESPEDESV").value = v1[1];
        document.getElementById("TICKET").value = v1[0];
        document.getElementById("TSERV").value = v1[2]; //tipo de servicio 1 dine inn 2 togo
        document.getElementById("ANT").innerHTML = parseFloat(v1[4]) - parseFloat(v1[5]);
        document.getElementById("ANTICIPO").value = parseFloat(v1[4]) - parseFloat(v1[5]);
        document.getElementById("IDMESERO").value = v1[6]; //PONEMESERO
        document.getElementById("IDMESAHD").value = v1[3]; //PONEMESERO

        document.getElementById("MPORC_DESCUENTO").value = v1[8]; //PORCDESCUENTO
        document.getElementById("MDESCUENTO").value = v1[7]; //MONTODESCUENTO
        document.getElementById("DESC").innerHTML = v1[7];
        document.getElementById("COMDESCUENTO").value = v1[9]; //COMENTARIODESCUENTO
        document.getElementById("MIDCONCEPTO").value = v1[10]; //IDCONCEPTO
        document.getElementById("MAUTORIZODESC").value = v1[11]; //AUTORIZODESCUENTO

        //pone comensales
        MuestraProductos("consultaproductos.php?USER=" + iduser + "&IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random(), "1", actpago);

        if (num_mesa > 0) document.getElementById("cmesa").click();
        //para que se actualizce
        ppal(); //ojo revisar si durante la carga este lo gana a MuestraProductos se puso typeof por si acaso  y es mejor ponerlo antes del clic
        Swal.close();
      }
    };
    ajax.send(null);
  } catch (error) {
    Swal.close();
  }
}

// function aceptaeliminar(iddetalle,user,iddord){ //elimina partida
//         if(iddetalle > 0) {
// 		razone=$("input[type='radio'][name='razonc']:checked").val();
// 		//alert('Eliminando por la razon'+razone);
// 		}
//         ajax=objetoAjax();
//         ajax.open("GET", 'borraprod_adm.php?IDDET='+iddetalle+'&IDORDEN='+iddord+'&USER='+user+'&RAZON='+razone);
//         ajax.onreadystatechange=function() {
//                 if (ajax.readyState==4) {
// 					//jQuery("#ctr").load("blank.php");
// 				MuestraProductos('consultaproductos.php?IDORDEN='+iddord+'&tm='+Math.random());
// 				$( "#razoneselimina" ).popup( "close" )
//                 }
//         }
//         ajax.send(null)
// }
function aceptaeliminar(iddetalle, user, iddord) {
  //elimina partida
  if (iddetalle > 0) {
    razone = $("input[type='radio'][name='razonc']:checked").val();
    //alert('Eliminando por la razon'+razone);
  }

  $.ajax({
    method: "GET",
    url: "eliminar_producto.php?IDDET=" + iddetalle + "&RAZON=" + razone,
    dataType: "json",
    error: function (response) {},
    success: function (data) {
      if (data.success == true) {
        // SI SE ELIMINO EL PRODUCTO
        $("#razoneselimina").popup("close");
        jQuery("#ctr").load("blank.php"); //Esto evita que se añadan modificadores a productos ya eliminados
        switch (data.status) {
          case 1: // SI NO SE A ENVIADO A COCINA
            Swal.fire({
              title: "Listo",
              text: data.message,
              icon: "success",
            }).then(() => {
              MuestraProductos("consultaproductos.php?IDORDEN=" + iddord + "&tm=" + Math.random());
            });
            break;
          case 3: // SI YA SE ENVIO A COCINA
            MuestraProductos("consultaproductos.php?IDORDEN=" + iddord + "&tm=" + Math.random());
            break;
        }
      } else {
        // SI OCURRIO UN FALLO, ENTRA AQUI (NO SE ELIMINO EL PRODUCTO)
        $("#razoneselimina").popup("close");
        Swal.fire({
          title: "¡Espera!",
          text: data.message,
          icon: "warning",
        });
        /* MuestraProductos("consultaproductos.php?IDORDEN=" + iddord + "&tm=" + Math.random()); */ // NO ES NECESARIO YA QUE NO SE ELIMINO NADA
      }
    },
  });
}

function borraPartida(param) {
  //elimina partida

  ajax = objetoAjax();
  ajax.open("GET", param);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      jQuery("#ctr").load("blank.php");
      MuestraProductos("consultaproductos.php?" + param + "&tm=" + Math.random());
    }
  };
  ajax.send(null);
}

function EnvioCocina(params) {
  //envia impresion a cocina
  //alert(params);
  ajax = objetoAjax();
  ajax.open("GET", params);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      //para que si hace logout MuestraProductos('consultaproductos.php?'+params+'&tm='+Math.random());

      hacelogout(); // Punto 35 de Bitacora - Mayo 2 2014
      // ppal();	document.getElementById('cerrar').click();	se comenta porque se solicita que al mandar a cocina se bloquee la sesion
    }
  };
  ajax.send(null);
}

function EnvioCocina2(params) {
  //envia impresion a cocina
  //alert(params);
  ajax = objetoAjax();
  ajax.open("GET", params);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      //para que si hace logout MuestraProductos('consultaproductos.php?'+params+'&tm='+Math.random());

      //Hara logout al finalizar todas las llamadas a esta funcion, aprado 9 dic 2025
      //hacelogout(); // Punto 35 de Bitacora - Mayo 2 2014
      
      // ppal();	document.getElementById('cerrar').click();	se comenta porque se solicita que al mandar a cocina se bloquee la sesion
    }
  };
  ajax.send(null);
}


function EnvioTicket(params) {
  //envia impresion a cocina
  //alert(params);
  ajax = objetoAjax();
  ajax.open("GET", params);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      MuestraProductos("consultaproductos.php?" + params + "&tm=" + Math.random());
      ppal();
      document.getElementById("cerrar").click();
    }
  };
  ajax.send(null);
}
function MuestraProductos(datos, MP, actpago = 0) {
  try {
    Swal.fire({
      title: "Cargando...",
      text: "Por favor espera un momento",
      allowOutsideClick: false,
      allowEscapeKey: false,
      didOpen: () => {
        Swal.showLoading();
      },
    });
    //actualiza lista de productos en ticket , MP ES MUESTRA PRINCIPAL , EJECUTAR FUNCION DE PPAL DESPUES DE CARGAR LOS PRODUCTOS Y MOSTRAR EL TOTAL
    divResultado = document.getElementById("ENVI");
    divResultado.innerHTML = "";
    ajax = objetoAjax();
    ajax.open("GET", datos);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        divResultado.innerHTML = ajax.responseText;


        const scriptRegex = /<script\b[^>]*>([\s\S]*?)<\/script>/gm;
        let match;
        while ((match = scriptRegex.exec(ajax.responseText)) !== null) {
            const scriptContent = match[1];
            const scriptElement = document.createElement('script');
            scriptElement.textContent = scriptContent;
            document.body.appendChild(scriptElement); // Append to body or desired location
        }

        var $box = $("#ENVI");

        // alert(ftotal.cta.value);
        //Llena subtotales de la cuenta
        TL = document.getElementById("SUBT");
        TL.innerHTML = ".";
        //alert(typeof ftotal.ctaf);
        if (typeof ftotal.ctaf != "undefined") TL.innerHTML = ftotal.ctaf.value; //si o se termino de cargar no ejecutar el total

        //alert('Producto Agregado');
        var height = $box.get(0).scrollHeight;
        $box.scrollTop(height);
        Swal.close();
        if (actpago == 1) preppago();
      }
    };
    ajax.send(null);
    Swal.close();
  } catch (error) {
    Swal.close();
  }
}

function Logueo(datos) {
  //obtioene id de usuario
  divResultado = document.getElementById("NUMERO");
  ajax = objetoAjax();
  ajax.open("GET", datos);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      // divResultado.value = ajax.responseText;
      if (document.getElementById("NUMERO").value > 0) {
        form1.submit();
      }
      //alert('Producto Agregado');
    }
  };
  ajax.send(null);
}

//Funciones de manejo teclad
function numero(num) {
  var palabra = document.getElementById("NUMERO").value;
  var nuevapalabra = palabra + num;
  document.getElementById("NUMERO").value = nuevapalabra;
  //entra(nuevapalabra);
}

//teclado pagos
function numero2(num) {
  var palabra = document.getElementById("NUMERO2").value;
  var nuevapalabra = palabra + num;
  document.getElementById("NUMERO2").value = nuevapalabra;
  //entra(nuevapalabra);
  calculacambio();
}

//teclado cambioproductos
function numero3(num) {
  var palabra = document.getElementById("NCANTIDAD").value;
  var nuevapalabra = palabra + num;
  document.getElementById("NCANTIDAD").value = nuevapalabra;
  //entra(nuevapalabra);
}

//teclado cambiohuespedes
function numero3M(num) {
  var palabra = document.getElementById("NUEVODATOMESA").value;
  var nuevapalabra = palabra + num;
  document.getElementById("NUEVODATOMESA").value = nuevapalabra;
  //entra(nuevapalabra);
}

//teclado cambiamesa
function numero3h(num) {
  var palabra = document.getElementById("NUEVODATOHUESPED").value;
  var nuevapalabra = palabra + num;
  document.getElementById("NUEVODATOHUESPED").value = nuevapalabra;
  //entra(nuevapalabra);
}

//teclado cortes
function numero4(num) {
  var palabra = document.getElementById("DEJARCAJA").value;
  var nuevapalabra = palabra + num;
  document.getElementById("DEJARCAJA").value = nuevapalabra;
  //entra(nuevapalabra);
}

//suma botones teclado prods
function suma(num) {
  var palabra = document.getElementById("NCANTIDAD").value;
  var nuevapalabra = palabra;

  if (parseFloat(palabra) + parseFloat(num) > 0) nuevapalabra = parseFloat(palabra) + parseFloat(num);
  document.getElementById("NCANTIDAD").value = nuevapalabra;
  //entra(nuevapalabra);
}
function sumah(num) {
  var palabra = document.getElementById("NUEVODATOHUESPED").value;
  var nuevapalabra = palabra;

  if (parseFloat(palabra) + parseFloat(num) > 0) nuevapalabra = parseFloat(palabra) + parseFloat(num);
  document.getElementById("NUEVODATOHUESPED").value = nuevapalabra;
  //entra(nuevapalabra);
}
function sumam(num) {
  var palabra = document.getElementById("NUEVODATOMESA").value;
  var nuevapalabra = palabra;

  if (parseFloat(palabra) + parseFloat(num) > 0) nuevapalabra = parseFloat(palabra) + parseFloat(num);
  document.getElementById("NUEVODATOMESA").value = nuevapalabra;
  //entra(nuevapalabra);
}

//preparaion de hoja pagos
function preppago() {
  // Se agregaron estos dos renglones porque estaba dejando valores anteriores en MONTO y CAMBIO , frios 16 may 2014
  document.getElementById("NUMERO2").value = "";

  if (document.getElementById("TICKET").value != "") {
    calculacambio();
    document.getElementById("CMESA").innerHTML = document.getElementById("MESA").innerHTML;
    document.getElementById("CTICKET").innerHTML = document.getElementById("norden").innerHTML; //document.getElementById('HUESP').innerHTML=huespedes;
    talc = parseFloat(document.getElementById("cta").value);
    anti = parseFloat(document.getElementById("ANTICIPO").value);

    //REVISA SI NO HAY DESCUENTO ANTERIOR Y LO APLICA
    document.getElementById("IDDESCUENTO").value = document.getElementById("MPORC_DESCUENTO").value;
    document.getElementById("txtKeyboard2").value = document.getElementById("COMDESCUENTO").value;

    if (isNaN(anti)) anti = 0;
    pend = talc - anti;
    vdescu = document.getElementById("MDESCUENTO").value;
    document.getElementById("CPAG").innerHTML = "$" + pend.toFixed(2);
    document.getElementById("DESCTO").innerHTML = "$" + vdescu;
    document.getElementById("DESCUENTO").value = vdescu;
    document.getElementById("myInput").value = 0;
    document.getElementById("CPAG2").innerHTML = "$" + (pend - vdescu).toFixed(2);

    //		document.getElementById('TICKET').value=ajax.responseText;
    // $('#IDDESCUENTO').val(0).selectmenu('refresh');

    //  document.getElementById('IDDESCUENTO').value=0;
    $.mobile.changePage("#cobro", {});
    var $select = $("#IDDESCUENTO");

    // $select.val(0);
    $select.selectmenu("refresh", true);
  } else {
    Swal.fire({
      icon: 'warning',
      title: 'Mesa requerida',
      text: 'Seleccione una mesa Primero'
    });
    //return;
    //document.getElementById('cerrarpagos').click();
  }
}

//aceptapago
function aceptapago(idorden, monto, idoperador, idOrigen) {
  descu = document.getElementById("DESCUENTO").value;
  descup = document.getElementById("IDDESCUENTO").value;
  apagar = document.getElementById("myInput").value;
  cambio = document.getElementById("CAMBIO").value;
  montoorden = document.getElementById("cta").value;
  come = document.getElementById("txtKeyboard2").value;
  if (idorden > 0 && idoperador > 0 && monto > 0) {
    forma = $("input[type='radio'][name='formapago']:checked").val();
    prop = document.getElementById("myInput").value;
    ajax = objetoAjax();
    ajax.open(
      "GET",
      "pago.php?IDORDEN=" +
        idorden +
        "&IDOPERADOR=" +
        idoperador +
        "&IDORIGEN=" +
        idOrigen +
        "&IDFORMAPAGO=" +
        forma +
        "&MONTO=" +
        monto +
        "&PROPINA=" +
        prop +
        "&DESCUENTO=" +
        descu +
        "&DESCUENTOP=" +
        descup +
        "&CAMBIO=" +
        cambio +
        "&MONTOORDEN=" +
        montoorden +
        "&COMENT=" +
        come +
        "&TM=" +
        Math.random()
    );
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        MuestraProductos("consultaproductos.php?IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random());

        // alert( ajax.responseText);
        //Llena subtotales de la cuenta
        //TL=document.getElementById('SUBT');
        //TL.innerHTML=ftotal.ctaf.value;
        consultaSiEstaPagada(idorden);
        /*
        alert('Cambio:'+cambio);
        document.getElementById('cerrarpagos').click();	
        regresamain();
        */
      }
    };
    ajax.send(null);
  }
}

function borraM() {
  document.getElementById("NUEVODATOMESA").value = "";
  //document.getElementById('NUEVODATOHUESPED').value=document.getElementById('HUESPEDESV').value;
}

function borrah() {
  document.getElementById("NUEVODATOHUESPED").value = "";
  //document.getElementById('NUEVODATOHUESPED').value=document.getElementById('HUESPEDESV').value;
}

function borra() {
  //limpia mesa

  document.getElementById("NUMERO").value = "";
  document.getElementById("NUMERO2").value = "";
  document.getElementById("NCANTIDAD").value = "";
  document.getElementById("DEJARCAJA").value = "";
  calculacambio();
}

function tecmesa(tp) {
  //pone titulo de mesa y oculta boton de huspedes
  TL = document.getElementById("TITULO");
  document.getElementById("TIPO").value = tp;
  TL.innerHTML = "N&uacute;mero de Mesa";
  bot = document.getElementById("aceptarmesa");
  bot.style.display = "";
  botw = document.getElementById("aceptargente");
  botw.style.display = "none";
}

function tecgente() {
  TL = document.getElementById("TITULO");
  TL.innerHTML = "Numero de Huespedes";
  bot = document.getElementById("aceptarmesa");
  bot.style.display = "none";
  botw = document.getElementById("aceptargente");
  botw.style.display = "";
}

function acepta() {
  //registra numero de mesa y pregunta numero de comensales despues
  var idorigen1 = document.getElementById("IDORIGEN").value;
  var idoperador1 = document.getElementById("IDOPERADOR").value;
  var mesa = document.getElementById("NUMMESA").value;
  var num = document.getElementById("NUMERO").value;

  if (document.getElementById("NUMERO").value != "") {
    document.getElementById("NUMMESA").value = num;
    validamesa(num);
    /*
    borra();
    tecgente();
    //oculta acepta mesa
    //window.parent.agregaorden(idoperador1,idorigen1,mesa);
    bot=document.getElementById('aceptar')
    bot.style.display='none';
    */
  } else {
    TL.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Indique el N&uacute;mero de Mesa para Continuar !</a>';
    //alert('Indique el Numero de Mesa !');
  }
}

function confirmahuespedes() {
  TL.innerHTML = "N&uacute;mero de Huespedes";
  document.getElementById("aceptargente").style.display = "";
  // ejecuta codigo para generar orden
  var num = document.getElementById("NUMERO").value;
  var idorigen1 = document.getElementById("IDORIGEN").value;
  var idoperador1 = document.getElementById("IDOPERADOR").value;
  var mesa = document.getElementById("NUMMESA").value;
  var tipo = document.getElementById("TIPO").value;

  borra();

  //oculta acepta huesp
  window.parent.agregaorden(idoperador1, idorigen1, mesa, num, tipo);
  tecmesa();
  document.getElementById("NUMMESA").value = ""; //limpia mesa
}

function noconfirmahuespedes() {
  TL.innerHTML = "N&uacute;mero de Huespedes";
  document.getElementById("aceptargente").style.display = "";
  document.getElementById("NUMERO").value = "";
}

function acepta2() {
  //registra el numero de nuespedes y abre la orden
  var idorigen1 = document.getElementById("IDORIGEN").value;
  var idoperador1 = document.getElementById("IDOPERADOR").value;
  var mesa = document.getElementById("NUMMESA").value;
  var tipo = document.getElementById("TIPO").value;

  if (document.getElementById("NUMERO").value != "") {
    if (document.getElementById("NUMERO").value <= 0) {
      TL.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >El numero de Huespedes debe ser como Minimo 1</a>';
      borra();
    } else {
      // Valida so son Once Huspedes
      if (document.getElementById("NUMERO").value > 10 && document.getElementById("NUMERO").value <= 30) {
        var ctos = document.getElementById("NUMERO").value;
        document.getElementById("aceptargente").style.display = "none";
        TL.innerHTML =
          '<a style="color:#000; background-color:#FFFF00;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Esta Seguro de que son ' +
          ctos +
          ' Huespedes ? </a><button style="color:#FFF; background-color:#339900;" id="dicesi" class="ui-btn ui-btn-inline" onclick="confirmahuespedes();">SI</button><button style="color:#FFF; background-color:#FF0000;" id="diceno" class="ui-btn ui-btn-inline" onclick="noconfirmahuespedes();">NO</button>';
      } else {
        if (document.getElementById("NUMERO").value > 30) {
          TL.innerHTML =
            '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >El numero de Huespedes No Puede ser Mayor a 30 <br> Consulte al Administrador del Sistema !</a>';
        } else {
          var num = document.getElementById("NUMERO").value;

          borra();

          //oculta acepta huesp
          window.parent.agregaorden(idoperador1, idorigen1, mesa, num, tipo);
          tecmesa();
          document.getElementById("NUMMESA").value = ""; //limpia mesa
        }
      }
    }
  } else {
    TL.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Indique el numero de Huespedes debe ser como Minimo 1</a>';
    //alert('Indique el N�mero de Hu&eacute;spedes !');
  }
}

function entra(clave) {
  Logueo("logueo.php?CLAVE=" + clave);
}

function validamesa(mm) {
  TL = document.getElementById("TITULO");
  TL.innerHTML = "N&uacute;mero de Mesa";
  ajax = objetoAjax();
  ajax.open("GET", "validamesa.php?MESA=" + mm + "&tm=" + Math.random());
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      if (ajax.responseText == 1) {
        borra();
        tecgente();
        //oculta acepta mesa
        //window.parent.agregaorden(idoperador1,idorigen1,mesa);
        bot = document.getElementById("aceptar");
        bot.style.display = "none";
      } else {
        if (ajax.responseText == 2) {
          TL.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' + mm + " Ya esta ocupada</a>";
          //alert('La mesa Ya esta ocupdad y no puede ser abierta 2 veces , Solicite su liberacion!');
          borra();
        } else {
          //document.getElementById('MensajeError').html('La Mesa No Existe !');
          //alert('La mesa No existe , Ingrese una mesa Valida !');
          TL.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' + mm + " No Existe</a>";
          borra();
        }
      }
    }
  };
  ajax.send(null);
}

// AQUI SE LLAMA EL LOGOUT DESPUES DE DARLE CLICK AL BOTON
function hacelogout() {
  ajax = objetoAjax();
  ajax.open("GET", "logout.php?" + "tm=" + Math.random() + "&LOG=1");
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      /* fetch("registrar_logout.php").then(() => (window.location = "index.php")); */
      window.location = "index.php";
      //$.mobile.navigate("acceso.php", { transition: "slideup", changeHash: false });
    }
  };
  ajax.send(null);
}

function regresamain() {
  ajax = objetoAjax();
  ajax.open("GET", "main.php" + "&tm=" + Math.random());
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      window.location = "main.php";
    }
  };
  ajax.send(null);
}

function vercorte() {
  //muestra corte de efectivo de caja
  jQuery("#CORTE").load("corte.php?tm=" + Math.random()); //.load(url);
  jQuery("#CORTES_REIMPRIMIR").load("corte_reimprimir.php?t=" + Math.random());
  jQuery("#CORTE_INFORMACION").load("corte_informacion.php?t=" + Math.random());
  jQuery("#RECOLECCIONES_REIMPRIMIR").load("recolecciones_reimprimir.php?t=" + Math.random());
}

function ccaja() {
  //muestra corte de efectivo de caja
  jQuery("#CORTER").load("corte2.php?tm=" + Math.random()); //.load(url);
}

function verabiertas() {
  //muestra corte de efectivo de caja
  jQuery("#CORTE").load("abiertas.php?tm=" + Math.random()); //.load(url);
  jQuery("#ABIERTAS_INFORMACION").load("abiertas_informacion.php?t=" + Math.random());
}

function vercancelaciones() {
  //muestra tickets de cancelación de cocina
  jQuery("#CANCELACIONES_REIMPRIMIR").load("cancelaciones_reimprimir.php?t=" + Math.random());
}

function aceptanuevacantidad() {
  //registra nuevacantidad
  var num = document.getElementById("NCANTIDAD").value;
  var idet = document.getElementById("IDDET").value;
  var idh = document.getElementById("IDHUES").value;
  var ido = document.getElementById("TICKET").value;
  var idOperador = document.getElementById("IDOPERADOR").value;
  var idOrigen = document.getElementById("IDORIGEN").value;

  if (num > 0 && idet > 0) {
    //borra();

    //oculta acepta huesp
    aplicacambio("cambiacant.php?IDDET=" + idet + "&CANT=" + num + "&IDHUESPED=" + idh + "&IDORDEN=" + ido + "&IDOPERADOR=" + idOperador + "&IDORIGEN=" + idOrigen + "&tm=" + Math.random(), ido);
  } else {
    Swal.fire({
      icon: 'warning',
      title: 'Valor inválido',
      text: 'Debe ser mayor que cero.'
    });
  }
}

function aplicacambio(params, idorden) {
  //envia impresion a cocinacambio huesped y cambio cantidad
  //alert(params);
  ajax = objetoAjax();
  ajax.open("GET", params);
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      MuestraProductos("consultaproductos.php?IDORDEN=" + idorden + "&tm=" + Math.random());
      //ppal();	document.getElementById('cerrar').click();
      $("#teclado2").popup("close");
    }
  };
  ajax.send(null);
}

function comboshuespedes(nh) {
  //llena los combos apra huespedes segun mesa
  num = parseFloat(document.getElementById("HUESPEDESV").value);

  document.getElementById("IDHUES").innerHTML = ""; //limpia las opciones
  idh = document.getElementById("IDHUES");
  for (h = 1; h <= num; h++) {
    idh.options[idh.options.length] = new Option(h, h);
  }

  idh.value = nh;
  var $select = $("#IDHUES");
  $select.selectmenu("refresh", true);
  // $("#HUESPEDESV").val(nh);
  // $('.IDHUES').selectmenu().selectmenu('refresh', true);
}

//separar mes
function separarmesac(idoperador, idorigen) {
  // separa mesa por comensal
  Swal.fire({
    title: "¿Confirmar separación?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, separar",
    cancelButtonText: "Cancelar"
  }).then((result) => {
    if (!result.isConfirmed) return;

    const idorden = document.getElementById("TICKET").value;
    const params = "dividemesa.php?IDORDEN=" + idorden + "&FORMA=1&tm=" + Math.random() + "&IDOPERADOR=" + idoperador + "&IDORIGEN=" + idorigen;

    const ajax = objetoAjax();
    ajax.open("GET", params);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        let response = ajax.responseText;
        Swal.fire({ icon: response === "Mesa dividida" ? "success" : "info", title: response });
        if (response == "Mesa dividida") {
          MuestraProductos("consultaproductos.php?IDORDEN=" + idorden + "&tm=" + Math.random());
          $("#rightpanel2").popup("close");
        }
      }
    };
    ajax.send(null);
  });
}

function listamesas() {
  //muestra corte de efectivo de caja
  jQuery("#CORTE").load("abiertasselect.php?tm=" + Math.random()); //.load(url);
  $("input[type='radio']").checkboxradio();
  $("input[type='radio']").checkboxradio("refresh");
}

function arrsepara(quien) {
  //crea array para unir mesas
  ids = document.getElementById("TICKETSUNIR").value;
  if (quien.checked) {
    document.getElementById("TICKETSUNIR").value = ids + "," + quien.value;
  }

  if (!quien.checked) {
    quita = "," + quien.value;
    document.getElementById("TICKETSUNIR").value = ids.replace(quita, "");
  }
}

function unirmesas() {
  // une las mesas seleccionadas
  Swal.fire({
    title: "¿Confirmar unión de mesas?",
    icon: "question",
    showCancelButton: true,
    confirmButtonText: "Sí, unir",
    cancelButtonText: "Cancelar"
  }).then((result) => {
    if (!result.isConfirmed) return;

    const idordenes = document.getElementById("TICKETSUNIR").value;
    const idorigen1 = document.getElementById("IDORIGEN").value;
    const idoperador1 = document.getElementById("IDOPERADOR").value;
    const v1 = idordenes.split(",");
    const params = "unemesa.php?IDORDEN=" + v1[1] + "&IDS=" + idordenes + "&FORMA=1&tm=" + Math.random() + "&IDOPERADOR=" + idoperador1 + "&IDORIGEN=" + idorigen1;

    const ajax = objetoAjax();
    ajax.open("GET", params);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        const nvacta = ajax.responseText;
        traemesa("torden.php?IDORDEN=" + nvacta, "", "");
      }
    };
    ajax.send(null);
  });
}

function MuestraProductosMesa_origen(dato1, dato2) {
  //envia impresion a cocina
  //alert(params);
  //alert('Buscando Orden'+dato2);
  jQuery("#mesao").load("consultaproductosT.php?MESA=" + dato1 + "&IDORDEN=" + dato2 + "&t=" + Math.random() / 2);
  /*
  ddonde=document.getElementById('mesao');
  ajax=objetoAjax();
  ajax.open("GET",'consultaproductosT.php?MESA='+dato1+'&IDORDEN='+dato2+'&t='+(Math.random() / 2));
  ajax.onreadystatechange=function() {
      if (ajax.readyState==4) {
      //alert(ajax.responseText);
      ddonde.innerHTML=ajax.responseText;	
      }
  }
  ajax.send(null)
  */
}

function MuestraProductosMesa_destino(xdato1, xdato2) {
  //envia impresion a cocina
  //alert(params);
  //alert('Buscando Orden'+dato2);
  jQuery("#mesad").load("consultaproductosT2.php?MESA=" + xdato1 + "&IDORDEN=" + xdato2 + "&t=" + Math.random());
  /*
  xddonde=document.getElementById('mesad');
  ajax=objetoAjax();
  ajax.open("GET",'consultaproductosT2.php?MESA='+xdato1+'&IDORDEN='+xdato2+'&t='+Math.random());
  ajax.onreadystatechange=function() {
      if (ajax.readyState==4) {
      //alert(ajax.responseText);
      xddonde.innerHTML=ajax.responseText;	
      }
  }
  ajax.send(null)
  */
}

function traemesaO(quparseFloator1) {
  var res1 = quparseFloator1.split(",");
  xmesa1 = res1[0];
  xidorden1 = res1[1];
  document.getElementById("IDORDEN1").value = xidorden1;
  veelboton();
  MuestraProductosMesa_origen(xmesa1, xidorden1);
  //limpiavals();
}

function veelboton() {
  if (document.getElementById("IDORDEN1").value > 0 && document.getElementById("IDORDEN2").value > 0 && document.getElementById("IDPRODST").value != "0") {
    document.getElementById("btntransf").style.display = "";
  }
}

function traemesaD(quparseFloator) {
  var res = quparseFloator.split(",");
  xmesa = res[0];
  xidorden = res[1];
  document.getElementById("IDORDEN2").value = xidorden;
  veelboton();
  MuestraProductosMesa_destino(xmesa, xidorden);
  //limpiavals();
}

/*
function selecciona(cualreg) //se dejo de usar rol eliminar en proxima revision
{

var idsprods=document.getElementById('IDPRODS').value;
//alert(cualreg);	
document.getElementById('renglon'+cualreg).style.background='#FFFF00';
document.getElementById('IDPRODS').value=idsprods+','+cualreg;
veelboton();
}
*/

function arrsepara2(quien) {
  //crea array para unir mesas
  ids = document.getElementById("IDPRODST").value;
  if (quien.checked) {
    document.getElementById("IDPRODST").value = ids + "," + quien.value;
    veelboton();
  }

  if (!quien.checked) {
    quita = "," + quien.value;
    document.getElementById("IDPRODST").value = ids.replace(quita, "");
    veelboton();
  }
}

function ActualizaTransferencia(v_idorden_1, v_idorden_2, v_idprods_1) {
  //envia impresion a cocina

  ajax = objetoAjax();
  ajax.open("GET", "acttransferencia.php?IDORDEN1=" + v_idorden_1 + "&IDORDEN2=" + v_idorden_2 + "&PRODS=" + v_idprods_1 + "&t=" + Math.random());
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      let response = ajax.responseText;
      Swal.fire({ icon: response === "Transferencia exitosa" ? "success" : "info", title: response });
      if (response == "Transferencia exitosa") {
        RefrescaMesas(v_idorden_1, v_idorden_2);
      }
    }
  };
  ajax.send(null);
}

function RefrescaMesas(orden_uno, orden_dos) {
  //f refrescar el contenido de los tickets despues de trasnferir
  document.getElementById("IDPRODST").value = "0";
  MuestraProductosMesa_origen("1", orden_uno);
  MuestraProductosMesa_destino("0", orden_dos);
  document.getElementById("btntransf").style.display = "none";
  document.getElementById("elresultado").innerHTML = "La transferencia se Realizo con Exito !";
}

function ftransfiere(v1, v2, v3) {
  //funcion para transferir productos de un ticket a otro
  var idorden_1 = v1;
  var idorden_2 = v2;
  var idprods_1 = v3;
  ActualizaTransferencia(idorden_1, idorden_2, idprods_1);
}

function aplicadesc() {
  //aplica descuento a ticket
  var eld = parseFloat(document.getElementById("IDDESCUENTO").value);
  var tl = parseFloat(document.getElementById("cta").value);
  var tdesc = tl * (eld / 100);
  talc = parseFloat(document.getElementById("cta").value);
  anti = parseFloat(document.getElementById("ANTICIPO").value);
  if (isNaN(anti)) anti = 0;
  pend = talc - anti;
  var nsaldo = pend - tdesc;
  document.getElementById("DESCTO").innerHTML = "$" + tdesc.toFixed(2);
  document.getElementById("DESCUENTO").value = tdesc;
  document.getElementById("CPAG2").innerHTML = "$" + nsaldo.toFixed(2);

  calculacambio();
}

function aplicadesc2() {
  //aplica descuento a ticket
  var eld = parseFloat(document.getElementById("IDDESCUENTO").value);
  var tl = parseFloat(document.getElementById("cta").value);
  var tdesc = document.getElementById("DESCUENTO").value;
  tdesc = tdesc.replace(/^0+/, "");
  tdesc = parseFloat(tdesc);
  talc = parseFloat(document.getElementById("cta").value);
  anti = parseFloat(document.getElementById("ANTICIPO").value);
  if (isNaN(anti)) anti = 0;
  pend = talc - anti;
  var nsaldo = pend - tdesc;
  if (nsaldo < 0) {
    //demasiado descuento
    tdesc = talc;
    pend = talc - anti;
    nsaldo = pend - tdesc;
  }
  document.getElementById("DESCTO").innerHTML = "$" + tdesc.toFixed(2);
  document.getElementById("DESCUENTO").value = tdesc;
  $("input[id=DESCUENTO]").val(tdesc);
  //alert(nsaldo);
  document.getElementById("CPAG2").innerHTML = "$" + nsaldo.toFixed(2);

  calculacambio();
}

function calculacambio() {
  //calcula cambio durante el pago de orden

  descu = parseFloat(document.getElementById("DESCUENTO").value);
  descup = document.getElementById("IDDESCUENTO").value;
  propina = parseFloat(document.getElementById("myInput").value);

  if (isNaN(propina)) {
    propina = 0;
  }
  //cambio=parseFloat(document.getElementById('CAMBIO').value);
  talc = parseFloat(document.getElementById("cta").value);
  anti = parseFloat(document.getElementById("ANTICIPO").value);
  if (isNaN(anti)) anti = 0;

  tl = talc - anti;
  tdesc = parseFloat(document.getElementById("DESCUENTO").value);

  if ($("#radio-choice-h-12").is(":checked")) {
    pa = parseFloat(document.getElementById("NUMERO2").value) * parseFloat(document.getElementById("TIPOCAMBIO").value);
    if (document.getElementById("NUMERO2").value > 0) {
      document.getElementById("conversion").innerHTML = "$" + document.getElementById("NUMERO2").value + " USD - $ " + pa + " Pesos";
    }
  } else {
    pa = parseFloat(document.getElementById("NUMERO2").value);
  }

  apag = tl - tdesc;
  if (pa - apag > 0 && pa - apag < propina) {
    //no puede dar mas propina de la que sobra de cambio

    propina = pa - apag;

    document.getElementById("myInput").value = propina;
  }

  cambio = pa - apag - propina;

  if ($("#radio-choice-h-13").is(":checked") || $("#radio-choice-h-14").is(":checked") || $("#radio-choice-h-15").is(":checked")) {
    //sin forma de pago es tarjeta de credito el excedente se va a propina y no a cambio

    cambio = 0;
    propina = pa - apag;
    if (propina < 0) propina = 0;
    document.getElementById("myInput").value = propina;
  }

  if (cambio < 0) cambio = 0;
  if (isNaN(pa)) {
    pa = 0;
    cambio = 0;
  }

  document.getElementById("CAMBIO").value = cambio.toFixed(2);

  // document.getElementById('CMESA').innerHTML=document.getElementById('MESA').innerHTML ;
  //document.getElementById('CTICKET').innerHTML	=document.getElementById('norden').innerHTML;				//document.getElementById('HUESP').innerHTML=huespedes;
}

function recoge() {
  // saca efectivo de caja para recolectarse
  const monto = parseFloat(document.getElementById("RECOLE").value);
  const efvo = parseFloat(document.getElementById("IDEFVO").value);
  const idop = document.getElementById("IDOPERADOR").value;
  const idOrigen = document.getElementById("IDORIGEN").value;

  Swal.fire({
    title: "¿Confirmar retiro?",
    html: `<div style="text-align:left"><p><b>Monto a retirar:</b> $${(isNaN(monto)?0:monto).toFixed(2)}</p><p><b>Efectivo disponible:</b> $${(isNaN(efvo)?0:efvo).toFixed(2)}</p></div>`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, retirar",
    cancelButtonText: "Cancelar"
  }).then((result) => {
    if (!result.isConfirmed) return;

    if (isNaN(monto) || monto <= 0) {
      Swal.fire({ icon: "warning", title: "Monto inválido", text: "Debe ingresar un monto mayor a 0" });
      return;
    }
    if (monto > efvo) {
      Swal.fire({ icon: "error", title: "Efectivo insuficiente", text: "Debe poner menos o igual que el efectivo existente" });
      return;
    }

    const param = "retiraefvo.php?MONTO=" + monto + "&IDOPERADOR=" + idop + "&IDORIGEN=" + idOrigen + "&t=" + Math.random();
    const ajax = objetoAjax();
    ajax.open("GET", param);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        Swal.fire({ icon: "success", title: "Retiro exitoso", timer: 1200, showConfirmButton: false });
        vercorte();
      }
    };
    ajax.send(null);
  });
}

function recoleccion() {
  const monto = parseFloat($("#CANTIDAD_RECOLECTAR").val()) || 0;
  const efvo = parseFloat($("#IDEFVO").val()) || 0;
  const idop = $("#IDOPERADOR").val();
  const idOrigen = $("#IDORIGEN").val();

  if (monto <= 0) {
      Swal.fire({
          icon: "warning",
          title: "Monto inválido",
          text: "Debe ingresar un monto mayor a 0"
      });
      return;
  }

  Swal.fire({
      title: "¿Confirmar retiro?",
      html: `
          <div style="text-align:left">
              <p><b>Monto a retirar:</b> $${monto.toFixed(2)}</p>
              <p><b>Efectivo disponible:</b> $${efvo.toFixed(2)}</p>
          </div>
      `,
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, retirar",
      cancelButtonText: "Cancelar",
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6"
  }).then((result) => {
      if (!result.isConfirmed) return;

      if (monto > efvo) {
          Swal.fire({
              icon: "error",
              title: "Efectivo insuficiente",
              html: `
                  <p>No hay suficiente efectivo para realizar el retiro.</p>
                  <p><b>Disponible:</b> $${efvo.toFixed(2)}</p>
              `
          });
          return;
      }

      $.ajax({
          url: "retiraefvo.php",
          type: "GET",
          data: {
              MONTO: monto,
              IDOPERADOR: idop,
              IDORIGEN: idOrigen,
              t: Math.random()
          },
          beforeSend: function () {
              Swal.fire({
                  title: "Procesando retiro",
                  text: "Espere un momento...",
                  allowOutsideClick: false,
                  allowEscapeKey: false,
                  didOpen: () => {
                      Swal.showLoading();
                  }
              });
          },
          success: function () {
              Swal.fire({
                  icon: "success",
                  title: "Retiro exitoso",
                  html: `<b>Monto retirado:</b> $${monto.toFixed(2)}`,
                  timer: 1500,
                  showConfirmButton: false
              });

              jQuery("#CORTE_INFORMACION").load("corte_informacion.php");
              $("#CANTIDAD_RECOLECTAR").val('');
              jQuery("#RECOLECCIONES_REIMPRIMIR").load("recolecciones_reimprimir.php?t=" + Math.random());
          },
          error: function () {
              Swal.fire({
                  icon: "error",
                  title: "Error",
                  text: "No fue posible realizar el retiro"
              });
          }
      });
  });
}


function verprop() {
  //muestra corte de PROPINAS PARA PAGARLAS
  jQuery("#CORTE").load("corteprops.php?tm=" + Math.random()); //.load(url);
  jQuery("#PROPINAS_REIMPRIMIR").load("propinas_reimprimir.php?t=" + Math.random());
  jQuery("#PROPINAS_INFORMACION").load("propinas_informacion.php?t=" + Math.random());
}

function recogeprops() {
  // Mantener compatibilidad: delega al flujo modernizado
  return recolectaPropinas();
}

function recolectaPropinas() {
  // saca efectivo de caja para PAGAR PROPINAS

  let monto    = parseFloat($("#TLPROPS").val());
  let efvo     = parseFloat($("#EFVOCAJA").val());
  let idop     = $("#IDOPERADOR").val();
  let idOrigen = $("#IDORIGEN").val();

  if (isNaN(monto)) monto = 0;
  if (isNaN(efvo)) efvo = 0;

  // No hay propinas
  if (monto <= 0) {
      Swal.fire({
          icon: "warning",
          title: "Sin propinas",
          text: "No hay propinas por pagar."
      });
      return;
  }

  // Efectivo insuficiente
  if (monto > efvo) {
      Swal.fire({
          icon: "error",
          title: "Efectivo insuficiente",
          text: `Solo hay $${efvo.toFixed(2)} disponibles en caja.`
      });
      return;
  }

  // Confirmación
  Swal.fire({
      title: "¿Confirmar retiro?",
      html: `
          <p>Se retirarán <b>$${monto.toFixed(2)}</b> para pagar propinas.</p>
          <p><small>Efectivo en caja: $${efvo.toFixed(2)}</small></p>
      `,
      icon: "question",
      showCancelButton: true,
      confirmButtonText: "Sí, retirar",
      cancelButtonText: "Cancelar",
      reverseButtons: true
  }).then((result) => {

      if (!result.isConfirmed) return;

      $.ajax({
          url: "retiraefvoprops.php",
          type: "GET",
          data: {
              MONTO: monto,
              IDOPERADOR: idop,
              IDORIGEN: idOrigen,
              t: Math.random()
          },
          beforeSend: function () {
              Swal.fire({
                  title: "Procesando...",
                  text: "Realizando retiro de efectivo",
                  allowOutsideClick: false,
                  allowEscapeKey: false,
                  didOpen: () => Swal.showLoading()
              });
          },
          success: function () {
              Swal.fire({
                  icon: "success",
                  title: "Retiro exitoso",
                  text: "El pago de propinas se realizó correctamente."
              }).then(() => {
                  verprop();
              });
          },
          error: function () {
              Swal.fire({
                  icon: "error",
                  title: "Error",
                  text: "Ocurrió un problema al realizar el retiro."
              });
          }
      });

  });
}


function recogeprops_individual(idmesero) {
  // Mantener compatibilidad: delega al flujo modernizado
  return recolectaPropinaInvividual(idmesero);
}

function recolectaPropinaInvividual(idmesero) {
  // Obtener valores
  let monto     = parseFloat($("#TLPROPS").val());
  let efvo      = parseFloat($("#EFVOCAJA").val());
  let idop      = $("#IDOPERADOR").val();
  let idOrigen  = $("#IDORIGEN").val();

  // Normalizar valores
  if (isNaN(monto)) monto = 0;
  if (isNaN(efvo)) efvo = 0;

  // Validaciones iniciales
  if (monto <= 0) {
      Swal.fire({
          icon: "warning",
          title: "Monto inválido",
          text: "No hay propinas por pagar."
      });
      return;
  }

  if (monto > efvo) {
      Swal.fire({
          icon: "error",
          title: "Efectivo insuficiente",
          text: `Solo hay $${efvo.toFixed(2)} disponibles en caja.`
      });
      return;
  }

  // Confirmación
  Swal.fire({
      title: "¿Confirmar retiro?",
      html: `
          <p>Se retirarán <b>$${monto.toFixed(2)}</b> para pagar propinas.</p>
          <p><small>Efectivo en caja: $${efvo.toFixed(2)}</small></p>
      `,
      icon: "question",
      showCancelButton: true,
      confirmButtonText: "Sí, retirar",
      cancelButtonText: "Cancelar",
      reverseButtons: true
  }).then((result) => {

      if (!result.isConfirmed) return;

      // Llamada AJAX
      $.ajax({
          url: "retiraefvoprops_individual.php",
          type: "GET",
          data: {
              MONTO: monto,
              IDOPERADOR: idop,
              IDMESERO: idmesero,
              IDORIGEN: idOrigen,
              t: Math.random()
          },
          beforeSend: function () {
              Swal.fire({
                  title: "Procesando...",
                  text: "Realizando retiro de efectivo",
                  allowOutsideClick: false,
                  allowEscapeKey: false,
                  didOpen: () => Swal.showLoading()
              });
          },
          success: function (resp) {
              // Si tu PHP no regresa JSON, puedes omitir resp y solo mostrar éxito
              Swal.fire({
                  icon: "success",
                  title: "Retiro exitoso",
                  text: "El pago de propinas se realizó correctamente."
              }).then(() => {
                  verprop(); // refresca vista
              });
          },
          error: function (xhr, status, error) {
              Swal.fire({
                  icon: "error",
                  title: "Error",
                  text: "Ocurrió un problema al realizar el retiro."
              });
              console.log(error);
          }
      });

  });
}


function realizarcorte(idop, idorigen) {
  //cierra caja

  Swal.fire({
    title: '¿Realizar Corte de Caja?',
    text: "¿Está seguro que desea realizar el Corte?",
    icon: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Sí, realizar corte',
    cancelButtonText: 'Cancelar'
  }).then((result) => {
    if (result.isConfirmed) {
      efe = 0; //document.getElementById('DEJARCAJA').value;
      //Alejandro fernandez solicita que no quede nada en caja nunca 14may2014
      if (1 == 1) {
        // var idorigen1 = document.getElementById("IDORIGEN").value;
        //siempre deja algo en caja  efe>0
        params = "recolecta.php?FORMA=1&EFVO=" + efe + "&tm=" + Math.random() + "&IDOPERADOR=" + idop + "&IDORIGEN=" + idorigen;

        ajax = objetoAjax();
        ajax.open("GET", params);
        ajax.onreadystatechange = function () {
          if (ajax.readyState == 4) {
            Swal.fire({
              icon: 'success',
              title: '¡Completado!',
              text: 'Corte de Caja Terminado',
              timer: 2000,
              showConfirmButton: false
            });
            ccaja();
            //nvacta = ajax.responseText;
            //$( "#rightpanel2" ).popup( "close" )
          }
        };
        ajax.send(null);
      }
    }
  }); //fin de siempre deja algo en caja
}

function revisadolares(jk) {
  calculacambio();
  //alert(jk);
  if (jk == 2) {
    // Dolares
    document.getElementById("divisa").innerHTML = "(Dolares : TC : $ " + document.getElementById("TIPOCAMBIO").value + ")";
  } else {
    document.getElementById("divisa").innerHTML = "(Pesos)";
    document.getElementById("conversion").innerHTML = "";
    document.getElementById("CAMBIO").value = 0;
  }
}

function consultaSiEstaPagada(kualorden) {
  //revisa si la orden esta pagada o no

  ajax = objetoAjax();
  ajax.open("GET", "revisaordenpagada.php?IDO=" + kualorden + "&t=" + Math.random());
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
      //location.href=location.href;
      var EstaPagada = ajax.responseText;
      if (EstaPagada == 0) {
        Swal.fire({
          icon: "warning",
          title: "Pago incompleto",
          text: "La orden no se ha pagado completamente"
        });
        idorden = document.getElementById("TICKET").value;
        traemesa("torden.php?IDORDEN=" + idorden, "", "", "", "", 1);
      }
      if (EstaPagada == 1) {
        // printTicketVenta(1, 1);
        $("#cerrarpagos").click();
        // window.location.reload();
        //alert('La orden ha sido Pagada');
        // Cierra Ventana de Pago y va a Main
      }
    }
  };
  ajax.send(null);
}

// Funcion para modificar el numero de huespedes despues de consultar mesa

function agregahuesped(idORD, idORIGEN, huespedes, idOperador) {
  //guarda producto principal en ticket
  if (huespedes > 0) {
    if (huespedes < 30) {
      ajax = objetoAjax();
      ajax.open("GET", "actualizahuespedes.php?IDORDEN=" + idORD + "&IDORIGEN=" + idORIGEN + "&H=" + huespedes + "&IDOPERADOR=" + idOperador);
      ajax.onreadystatechange = function () {
        if (ajax.readyState == 4) {
          if (ajax.responseText == 1) { // MODIFICACION EXITOSA
            document.getElementById("HUESPEDESV").value = huespedes;
            document.getElementById("HUESP").innerHTML = huespedes;
            $("#teclado2huesped").popup("close");
          } else if (ajax.responseText == 2) { // CUENTA PAGADA. /* #### FALTA TERMINAR DE REALIZAR #### */
            $("#teclado2huesped").popup("close");
          }
        }
      };
      ajax.send(null);
    } // fin de if huespedes < 30
  } else {
    Swal.fire({ icon: "warning", title: "Número inválido", text: "El número de huéspedes debe ser al menos 1." });
    document.getElementById("NUEVODATOHUESPED").value = document.getElementById("HUESPEDESV").value;
  }
}

function lpagos() {
  //ver pagos v1
  jQuery("#pagosd").load("pagosselect.php?tm=" + Math.random()); //.load(url);
  // $("input[type='radio']").checkboxradio();
  //$("input[type='radio']").checkboxradio("refresh");
}

function lpagos2() {
  //ver pagos v2
  jQuery("#pagosd").load("pagos_select_v2.php?tm=" + Math.random()); //.load(url);
  // $("input[type='radio']").checkboxradio();
  //$("input[type='radio']").checkboxradio("refresh");
}

function eliminapago(idpago) {
  // elimina el pago y libera la mesa para pagar de nuevo solo si no se ha hecho corte
  Swal.fire({
    title: "¿Eliminar pago?",
    text: "Esta operación no es reversible",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "Cancelar"
  }).then((result) => {
    if (!result.isConfirmed) {
      Swal.fire({ icon: "info", title: "Operación cancelada", timer: 1200, showConfirmButton: false });
      return;
    }
    const ajax = objetoAjax();
    ajax.open("GET", "borrapago.php?IDPAGO=" + idpago);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        jQuery("#pagosd").load("pagosselect.php?tm=" + Math.random());
      }
    };
    ajax.send(null);
  });
}

function agregaopcion(eltexto) {
  //cra nueva orden
  idorden = parseFloat(document.getElementById("TICKET").value);
  idOperador = document.getElementById("IDOPERADOR").value;
  idOrden = document.getElementById("IDORIGEN").value;

  // Se agrego una verificacion de tamaño del comentario, para evitar que se extendiera demasiado sgodina/ccisneros 7/OCT/2025
  if (eltexto.length > 75) {
    Swal.fire({ icon: "warning", title: "Comentario muy largo", text: "El comentario no debe exceder los 75 caracteres." });
    return;
  }

  /* mesa = document.getElementById("MESA").textContent; */
  if (eltexto != "" && idorden > 0) {
    ajax = objetoAjax();
    ajax.open("GET", "agregarcomentarioaproducto.php?" + "IDORDEN=" + idorden + "&COMM=" + eltexto);
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        MuestraProductos("consultaproductos.php?IDORDEN=" + document.getElementById("TICKET").value + "&tm=" + Math.random());
        document.getElementById("txtKeyboard").value = "";
        //ppal();
      }
    };
    ajax.send(null);
  } // fin de IF Texto
  else {
    Swal.fire({ icon: "info", title: "Falta información", text: "Agregue un comentario y seleccione una mesa primero." });
  }
}

// Funcion para modificar el numero de mesa, OJO debe validarse de nuevo si la mesa esta

function agregamesa(idORD, idORIGEN, lamesa) {
  //guarda producto principal en ticket
  if (lamesa > 0) {
    validacionmesa(lamesa);
  } else {
    Swal.fire({ icon: "warning", title: "Mesa requerida", text: "Indique la mesa a la que requiere cambiar la orden." });
    document.getElementById("NUEVODATOMESA").value = document.getElementById("MESA").innerHTML;
  }
}

function validacionmesa(quemesa) {
  var MSJ = document.getElementById("MSJERROR");
  if (quemesa > 0) {
    ajax = objetoAjax();
    ajax.open("GET", "validamesa.php?MESA=" + quemesa + "&tm=" + Math.random());
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        if (ajax.responseText == 1) {
          //realiza el cambio de mesa despues de validar
          MSJ.innerHTML = "";
          hacecambiodemesa(quemesa);
        } else if (ajax.responseText == 2) {
          //REVISA SI NO HUBO CAMBIO DE MESA Y ENVIA CAMBIO DE MESERO SOLAMENTE
          mvieja = document.getElementById("MESA").innerHTML;
          if (mvieja != quemesa) {
            MSJ.innerHTML =
              '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' + quemesa + " Ya esta ocupada INTENTE CON OTRA MESA</a>";

            //alert('La mesa Ya esta # '+quemesa+'ocupada Intente con otra mesa!');
            borraM();
          }

          if (mvieja == quemesa) {
            // es la misma mesa revisa si hay cambio de mesero
            meseroviejo = document.getElementById("IDMESERO").value;
            meseronuevo = document.getElementById("IDOPERMESA").value;
            if (meseroviejo != meseronuevo) {
              //envia instruccion de cambio de mesero
              hacecambiodemesa(quemesa);
            } else {
              MSJ.innerHTML =
                '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' +
                quemesa +
                " es la misma a la que se quiere actualizar.</a>";
            }
          }
        } else if (ajax.responseText == 3) {
          MSJ.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' + quemesa + " ingresada no es valida</a>";
          borraM();
        } else {
          MSJ.innerHTML =
            '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La Mesa #' + quemesa + " No existe Ingrese una MESA VALIDA</a>";
          //alert('La mesa # '+quemesa+' No existe , Ingrese una mesa Valida !');
          borraM();
        }

        setTimeout(() => {
          MSJ.innerHTML = "";
        }, 5000);
      }
    };
    ajax.send(null);
  } // fin de if quemesa >0
}

// funcion para realizar el cambio de mesa despues de la validacion

// Funcion para modificar el numero de huespedes despues de consultar mesa

function hacecambiodemesa(datomesa) {
  //
  var MSJ = document.getElementById("MSJERROR");

  if (datomesa > 0) {
    var idORD = document.getElementById("TICKET").value;
    var idORIGEN = document.getElementById("IDORIGEN").value;
    var idMESERO = document.getElementById("IDOPERMESA").value;
    if (isNaN(idMESERO) || idMESERO <= 0) idMESERO = document.getElementById("IDMESERO").value; //evita cambiar si no hay mesero
    ajax = objetoAjax();
    ajax.open("GET", "actualizanumerodemesa.php?IDORDEN=" + idORD + "&IDORIGEN=" + idORIGEN + "&M=" + datomesa + "&IDOPERADOR=" + idMESERO + "&TM=" + Math.random());
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        if (ajax.responseText == 3) {
          MSJ.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >No tienes permiso para realizar esta accion</a>';
        } else if (ajax.responseText == 4) {
          MSJ.innerHTML =
            '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Ocurrio un problema, vuelva a ingresar los parametros nuevamente</a>';
        } else if (ajax.responseText == 5) {
          MSJ.innerHTML =
            '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Ocurrio un problema, el empleado seleccionado no es valido, selecciona un de nuevo a un empleado</a>';
        } else if (ajax.responseText == 6) {
          MSJ.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >La orden esta cerrada, no es posible realizar los cambios</a>';
        } else if (ajax.responseText == 1) {
          document.getElementById("MESA").innerHTML = datomesa;
          document.getElementById("ELMESERO").innerHTML = $("#IDOPERMESA option:selected").text();
          document.getElementById("IDMESERO").value = idMESERO;
          $("#teclado2mesa").popup("close");
        } else {
          MSJ.innerHTML = '<a style="color:#FFF; background-color:#FF0000;" class="ui-shadow ui-btn ui-corner-all" style="min-height:40px;" >Ocurrio un problema inesperado, intente de nuevo</a>';
        }
      }
    };
    ajax.send(null);
  } else {
    Swal.fire({ icon: "error", title: "No se pudo obtener la mesa" });
    document.getElementById("NUEVODATOMESA").value = document.getElementById("MESA").innerHTML;
  }
}

function reprint(noord) {
  //rol ago2014 Reimprimie ticket
  idORD = parseFloat(noord);
  ajax = objetoAjax();
  ajax.open("GET", "reimprime.php?IDORDEN=" + idORD + "&TM=" + Math.random());
  ajax.onreadystatechange = function () {
    if (ajax.readyState == 4) {
    }
  };
  ajax.send(null);
}

function verpagadas() {
  //muestra corte de efectivo de caja
  jQuery("#CORTE").load("pagadas.php?tm=" + Math.random()); //.load(url);
  jQuery("#CERRADAS_INFORMACION").load("pagadas_informacion.php?t=" + Math.random());
}

//rol sep 2014 funcion de guardar descuento
//preparacion de hoja descuentps
function prepdescu() {
  //
  document.getElementById("NUMERO2").value = "";

  if (document.getElementById("TICKET").value != "") {
    // calculacambio();
    document.getElementById("CMESA2").innerHTML = document.getElementById("MESA").innerHTML;
    document.getElementById("CTICKET2").innerHTML = document.getElementById("norden").innerHTML; //document.getElementById('HUESP').innerHTML=huespedes;
    talc = parseFloat(document.getElementById("cta").value);
    anti = parseFloat(document.getElementById("ANTICIPO").value) + parseFloat(document.getElementById("MDESCUENTO").value);
    if (isNaN(anti)) anti = 0;
    pend = talc - anti;
    document.getElementById("CPAG3").innerHTML = "$" + pend.toFixed(2);
    document.getElementById("DESCTO2").innerHTML = "$" + document.getElementById("MDESCUENTO").value;
    document.getElementById("DESCUENTO2").value = document.getElementById("MDESCUENTO").value;
    //document.getElementById('myInput').value=0;
    document.getElementById("CPAG4").innerHTML = "$" + pend.toFixed(2);

    //REVISA SI NO HAY DESCUENTO ANTERIOR Y LO APLICA
    document.getElementById("IDDESCUENTO2").value = document.getElementById("MPORC_DESCUENTO").value;
    document.getElementById("COMENDESC").value = document.getElementById("COMDESCUENTO").value;

    //		document.getElementById('TICKET').value=ajax.responseText;
    // $('#IDDESCUENTO').val(0).selectmenu('refresh');

    //  document.getElementById('IDDESCUENTO').value=0;
    $.mobile.changePage("#descuen", {});
    var $select = $("#IDDESCUENTO2");

    // $select.val(0);
    $select.selectmenu("refresh", true);
    //alert(document.getElementById('MPORC_DESCUENTO').value );
  } else {
    Swal.fire({ icon: "info", title: "Seleccione una mesa primero" });
    //return;
    //document.getElementById('cerrarpagos').click();
  }
}

function aplicadesc3() {
  //aplica descuento a ticket descuento porcentaje PREVIO A CIERRE
  var eld = parseFloat(document.getElementById("IDDESCUENTO2").value);
  var tl = parseFloat(document.getElementById("cta").value);
  var tdesc = document.getElementById("DESCUENTO2").value;
  var tdesc = tl * (eld / 100);
  tdesc = parseFloat(tdesc);
  talc = parseFloat(document.getElementById("cta").value);
  anti = parseFloat(document.getElementById("ANTICIPO").value);
  if (isNaN(anti)) anti = 0;
  pend = talc - anti;
  var nsaldo = pend - tdesc;
  if (nsaldo < 0) {
    //demasiado descuento
    tdesc = talc;
    pend = talc - anti;
    nsaldo = pend - tdesc;
  }
  document.getElementById("DESCTO2").innerHTML = "$" + tdesc.toFixed(2);
  document.getElementById("DESCUENTO2").value = tdesc;
  $("input[id=DESCUENTO2]").val(tdesc);
  //alert(nsaldo);
  document.getElementById("CPAG4").innerHTML = "$" + nsaldo.toFixed(2);

  //calculacambio();
}

function aplicadesc4() {
  //aplica descuento a ticket descuento manual, previo al cierre
  var eld = parseFloat(document.getElementById("IDDESCUENTO2").value);
  var tl = parseFloat(document.getElementById("cta").value);
  var tdesc = document.getElementById("DESCUENTO2").value;
  tdesc = tdesc.replace(/^0+/, "");
  tdesc = parseFloat(tdesc);
  talc = parseFloat(document.getElementById("cta").value);
  anti = parseFloat(document.getElementById("ANTICIPO").value);
  if (isNaN(anti)) anti = 0;
  pend = talc - anti;
  var nsaldo = pend - tdesc;
  if (nsaldo < 0) {
    //demasiado descuento
    tdesc = talc;
    pend = talc - anti;
    nsaldo = pend - tdesc;
  }
  document.getElementById("DESCTO2").innerHTML = "$" + tdesc.toFixed(2);
  document.getElementById("DESCUENTO2").value = tdesc;
  $("input[id=DESCUENTO2]").val(tdesc);
  //alert(nsaldo);
  document.getElementById("CPAG4").innerHTML = "$" + nsaldo.toFixed(2);

  //calculacambio();
}

//guarda descuento para aplicacion posterior
function savedesc() {
  idorden = document.getElementById("TICKET").value;
  monto = document.getElementById("cta").value;
  idoperador = document.getElementById("IDOPERADOR").value;
  idOrigen = document.getElementById("IDORIGEN").value;

  descu = document.getElementById("DESCUENTO2").value;
  descup = document.getElementById("IDDESCUENTO2").value;

  montoorden = document.getElementById("cta").value;
  come = document.getElementById("COMENDESC").value;
  if (idorden > 0 && idoperador > 0 && monto > 0) {
    forma = $("input[type='radio'][name='formapago']:checked").val();
    prop = document.getElementById("myInput").value;
    ajax = objetoAjax();
    ajax.open(
      "GET",
      "guardadesc.php?IDORDEN=" +
        idorden +
        "&IDOPERADOR=" +
        idoperador +
        "&IDORIGEN=" +
        idOrigen +
        "&IDFORMAPAGO=" +
        forma +
        "&MONTO=" +
        monto +
        "&PROPINA=" +
        prop +
        "&DESCUENTO=" +
        descu +
        "&DESCUENTOP=" +
        descup +
        "&COMENT=" +
        come +
        "&TM=" +
        Math.random()
    );
    ajax.onreadystatechange = function () {
      if (ajax.readyState == 4) {
        //alert( ajax.responseText);
        traemesa("torden.php?IDORDEN=" + idorden, 0, 0, 0, 0, 0);
        //Llena subtotales de la cuenta
        //TL=document.getElementById('SUBT');
        //TL.innerHTML=ftotal.ctaf.value;
        //consultaSiEstaPagada(idorden);
        /*
        alert('Cambio:'+cambio);
      	
        regresamain();
        */

        document.getElementById("cpagos").click();
      }
    };
    ajax.send(null);
  }
}

function divpartes(idorden, partes) {
  //funcion para dividir
  if (document.getElementById("TICKET").value != "") {
    if (idorden > 0) {
      idoperador = document.getElementById("IDOPERADOR").value;
      ajax = objetoAjax();
      ajax.open("GET", "dividepartes.php?IDORDEN=" + idorden + "&PARTES=" + partes + "&IDOPERADOR=" + idoperador + "&TM=" + Math.random());
      ajax.onreadystatechange = function () {
        if (ajax.readyState == 4) {
          let response = ajax.responseText;
          Swal.fire({ icon: response === "Mesa dividida" ? "success" : "info", title: response });
          if (response == "Mesa dividida") {
            traemesa("torden.php?IDORDEN=" + idorden, 0, 0, 0, 0, 0);
            document.getElementById("cpagosr").click();
          }
        }
      };
      ajax.send(null);
    }
  } else {
    Swal.fire({ icon: "info", title: "Seleccione una mesa primero" });
    //return;
    //document.getElementById('cerrarpagos').click();
  }
}
